/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.objectfile;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.openjena.atlas.lib.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFileLogger
implements ObjectFile {
    protected final ObjectFile other;
    private static Logger defaultLogger = LoggerFactory.getLogger(ObjectFile.class);
    private final Logger log;
    private final String label;

    public ObjectFileLogger(String label, ObjectFile other) {
        this.other = other;
        this.label = label;
        this.log = defaultLogger;
    }

    @Override
    public Block allocWrite(int maxBytes) {
        Block blk = this.other.allocWrite(maxBytes);
        this.info("allocWrite(" + maxBytes + ") -> " + blk.getId());
        return blk;
    }

    @Override
    public void completeWrite(Block buffer) {
        this.info("completeWrite(" + buffer.getId() + ")");
        this.other.completeWrite(buffer);
    }

    @Override
    public long write(ByteBuffer buffer) {
        this.info("write" + buffer);
        return this.other.write(buffer);
    }

    @Override
    public void reposition(long id) {
        this.info("reposition(" + id + ")");
        this.other.reposition(id);
    }

    @Override
    public ByteBuffer read(long id) {
        this.info("read(" + id + ")");
        return this.other.read(id);
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        this.info("all()");
        return this.other.all();
    }

    @Override
    public void truncate(long size) {
        this.info("truncate(" + size + ")");
        this.other.truncate(size);
    }

    public void sync() {
        this.info("sync");
        this.other.sync();
    }

    public void close() {
        this.info("close");
        this.other.close();
    }

    @Override
    public String getLabel() {
        return this.other.getLabel();
    }

    @Override
    public long length() {
        return this.other.length();
    }

    @Override
    public boolean isEmpty() {
        return this.other.isEmpty();
    }

    private void info(String string) {
        if (this.label != null) {
            string = this.label + ": " + string;
        }
        this.log.info(string);
    }
}

