/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import com.hp.hpl.jena.tdb.base.file.BufferChannelFile;
import com.hp.hpl.jena.tdb.base.file.BufferChannelMem;
import com.hp.hpl.jena.tdb.base.file.PlainFile;
import com.hp.hpl.jena.tdb.base.file.PlainFileMem;
import com.hp.hpl.jena.tdb.base.file.PlainFilePersistent;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFileStorage;
import com.hp.hpl.jena.tdb.base.objectfile.StringFile;

public class FileFactory {
    public static StringFile createStringFileDisk(String filename) {
        return new StringFile(FileFactory.createObjectFileDisk(filename));
    }

    public static StringFile createStringFileMem(String filename) {
        return new StringFile(FileFactory.createObjectFileMem(filename));
    }

    public static ObjectFile createObjectFileDisk(String filename) {
        BufferChannelFile file = new BufferChannelFile(filename);
        return new ObjectFileStorage(file);
    }

    public static ObjectFile createObjectFileMem(String filename) {
        BufferChannel file = BufferChannelMem.create(filename);
        return new ObjectFileStorage(file);
    }

    public static PlainFile createPlainFileDisk(String filename) {
        return new PlainFilePersistent(filename);
    }

    public static PlainFile createPlainFileMem() {
        return new PlainFileMem();
    }
}

