/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.file;

import com.hp.hpl.jena.tdb.base.file.ChannelManager;
import com.hp.hpl.jena.tdb.base.file.FileException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.lib.Closeable;
import org.openjena.atlas.lib.Sync;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBase
implements Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(FileBase.class);
    public final String filename;
    private FileChannel channel;
    public static boolean DEBUG = false;
    private final boolean DebugThis;
    private static long counter = 0L;
    private final long id = counter++;

    static FileBase create(String filename) {
        return new FileBase(filename);
    }

    static FileBase create(String filename, String mode) {
        return new FileBase(filename, mode);
    }

    private FileBase(String filename) {
        this(filename, "rw");
    }

    private FileBase(String filename, String mode) {
        this.DebugThis = false;
        if (this.DebugThis && log.isDebugEnabled()) {
            log.debug("open: [" + this.id + "]" + filename);
        }
        this.filename = filename;
        this.channel = ChannelManager.acquire(filename, mode);
    }

    public final FileChannel channel() {
        return this.channel;
    }

    public long size() {
        try {
            return this.channel.size();
        }
        catch (IOException ex) {
            IO.exception((IOException)ex);
            return -1L;
        }
    }

    public boolean isClosed() {
        return this.channel == null;
    }

    public void close() {
        if (this.DebugThis) {
            log.debug("close: [" + this.id + "]: " + this.filename);
        }
        ChannelManager.release(this.channel);
        this.channel = null;
    }

    public void sync() {
        if (this.DebugThis) {
            log.debug("sync: [" + this.id + "]: " + this.filename);
        }
        try {
            this.channel.force(false);
        }
        catch (IOException ex) {
            throw new FileException("FileBase.sync", ex);
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

