/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.block.BlockMgrWrapper;
import java.util.ArrayDeque;
import java.util.Deque;

public final class BlockMgrFreeChain
extends BlockMgrWrapper {
    private final Deque<Block> freeBlocks = new ArrayDeque<Block>();

    public BlockMgrFreeChain(BlockMgr blockMgr) {
        super(blockMgr);
    }

    public Block allocate(int blockSize) {
        if (!this.freeBlocks.isEmpty()) {
            Block block = this.freeBlocks.removeFirst();
            block.getByteBuffer().position(0);
            return block;
        }
        return super.allocate(blockSize);
    }

    public void free(Block block) {
        this.freeBlocks.add(block);
    }

    public boolean valid(int id) {
        for (Block blk : this.freeBlocks) {
            if (blk.getId() != (long)id) continue;
            return true;
        }
        return super.valid(id);
    }

    private boolean isFree(int id) {
        return this.freeBlocks.contains(id);
    }

    public void sync() {
        super.sync();
    }

    public String toString() {
        return "Free:" + super.toString();
    }
}

