/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.base.block;

import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockMgrBase;
import com.hp.hpl.jena.tdb.base.file.BlockAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockMgrFileAccess
extends BlockMgrBase {
    private static Logger log = LoggerFactory.getLogger(BlockMgrFileAccess.class);
    private final BlockAccess file;
    private boolean closed = false;
    private boolean syncNeeded = false;

    BlockMgrFileAccess(BlockAccess blockAccess, int blockSize) {
        super(blockAccess.getLabel(), blockSize);
        this.file = blockAccess;
    }

    protected Block allocate() {
        this.syncNeeded = true;
        return this.file.allocate(this.blockSize);
    }

    public Block promote(Block block) {
        return block;
    }

    public Block getReadIterator(long id) {
        return this.getBlock(id);
    }

    public Block getRead(long id) {
        return this.getBlock(id);
    }

    public Block getWrite(long id) {
        return this.getBlock(id);
    }

    private Block getBlock(long id) {
        Block block = this.file.read(id);
        return block;
    }

    public void release(Block block) {
    }

    public void write(Block block) {
        this.syncNeeded = true;
        this.file.write(block);
    }

    public void overwrite(Block block) {
        this.syncNeeded = true;
        this.file.overwrite(block);
    }

    public void free(Block block) {
    }

    public boolean valid(int id) {
        return this.file.valid(id);
    }

    public void sync() {
        if (this.syncNeeded) {
            this.file.sync();
        } else {
            this.syncNeeded = true;
        }
        this.syncNeeded = false;
    }

    public void syncForce() {
        this.file.sync();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.closed = true;
        this.file.close();
    }

    public boolean isEmpty() {
        return this.file.isEmpty();
    }

    public String toString() {
        return String.format("BlockMgrFileAccess[%d bytes]:%s", this.blockSize, this.file);
    }

    protected Logger log() {
        return log;
    }
}

