/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signature;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.oauth.OAuth;
import net.oauth.OAuthException;
import net.oauth.signature.OAuthSignatureMethod;

class HMAC_SHA1
extends OAuthSignatureMethod {
    private static final String ENCODING = "UTF-8";
    private static final String MAC_NAME = "HmacSHA1";
    private SecretKey key = null;

    HMAC_SHA1() {
    }

    protected String getSignature(String baseString) throws OAuthException {
        try {
            String signature = HMAC_SHA1.base64Encode(this.computeSignature(baseString));
            return signature;
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthException(e);
        }
    }

    protected boolean isValid(String signature, String baseString) throws OAuthException {
        try {
            byte[] expected = this.computeSignature(baseString);
            byte[] actual = HMAC_SHA1.decodeBase64(signature);
            return Arrays.equals(expected, actual);
        }
        catch (GeneralSecurityException e) {
            throw new OAuthException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] computeSignature(String baseString) throws GeneralSecurityException, UnsupportedEncodingException {
        SecretKey key = null;
        HMAC_SHA1 hMAC_SHA1 = this;
        synchronized (hMAC_SHA1) {
            if (this.key == null) {
                String keyString = OAuth.percentEncode(this.getConsumerSecret()) + '&' + OAuth.percentEncode(this.getTokenSecret());
                byte[] keyBytes = keyString.getBytes(ENCODING);
                this.key = new SecretKeySpec(keyBytes, MAC_NAME);
            }
            key = this.key;
        }
        Mac mac = Mac.getInstance(MAC_NAME);
        mac.init(key);
        byte[] text = baseString.getBytes(ENCODING);
        return mac.doFinal(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConsumerSecret(String consumerSecret) {
        HMAC_SHA1 hMAC_SHA1 = this;
        synchronized (hMAC_SHA1) {
            this.key = null;
        }
        super.setConsumerSecret(consumerSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTokenSecret(String tokenSecret) {
        HMAC_SHA1 hMAC_SHA1 = this;
        synchronized (hMAC_SHA1) {
            this.key = null;
        }
        super.setTokenSecret(tokenSecret);
    }
}

