/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.eclipse.lyo.client.oslc.OslcClient;
import org.eclipse.lyo.client.oslc.OslcOAuthClient;
import org.eclipse.lyo.client.oslc.resources.OslcQueryParameters;
import org.eclipse.lyo.client.oslc.resources.OslcQueryResult;

public class OslcQuery {
    private final OslcClient oslcClient;
    private final String capabilityUrl;
    private String queryUrl;
    private final int pageSize;
    private final Resource queryResource;
    private final String where;
    private final String select;
    private final String orderBy;
    private final String searchTerms;
    private final String prefix;

    public OslcQuery(OslcClient oslcClient, String capabilityUrl) {
        this(oslcClient, capabilityUrl, 0);
    }

    public OslcQuery(OslcClient oslcClient, String capabilityUrl, OslcQueryParameters oslcQueryParams) {
        this(oslcClient, capabilityUrl, 0, oslcQueryParams);
    }

    public OslcQuery(OslcClient oslcClient, String capabilityUrl, int pageSize) {
        this(oslcClient, capabilityUrl, pageSize, null);
    }

    public OslcQuery(OslcClient oslcClient, String capabilityUrl, int pageSize, OslcQueryParameters oslcQueryParams) {
        this.oslcClient = oslcClient;
        this.capabilityUrl = capabilityUrl;
        int n = this.pageSize = pageSize < 1 ? 0 : pageSize;
        if (oslcQueryParams != null) {
            this.where = oslcQueryParams.getWhere();
            this.select = oslcQueryParams.getSelect();
            this.orderBy = oslcQueryParams.getOrderBy();
            this.searchTerms = oslcQueryParams.getSearchTerms();
            this.prefix = oslcQueryParams.getPrefix();
        } else {
            this.prefix = null;
            this.searchTerms = null;
            this.orderBy = null;
            this.select = null;
            this.where = null;
        }
        this.queryResource = this.createQueryResource();
        this.queryUrl = this.getQueryUrl();
    }

    OslcQuery(OslcQueryResult previousResult) {
        this(previousResult.getQuery(), previousResult.getNextPageUrl());
    }

    private OslcQuery(OslcQuery previousQuery, String nextPageUrl) {
        this(previousQuery.oslcClient, previousQuery.capabilityUrl, previousQuery.pageSize);
        this.queryUrl = nextPageUrl;
        this.queryResource.uri(nextPageUrl);
    }

    private Resource createQueryResource() {
        Resource resource = this.oslcClient.getQueryResource(this);
        resource.accept(new String[]{"application/rdf+xml"});
        resource.header("OSLC-Core-Version", new String[]{"2.0"});
        this.applyPagination(resource);
        this.applyOslcQueryParams(resource);
        return resource;
    }

    private void applyPagination(Resource resource) {
        if (this.pageSize > 0) {
            resource.queryParam("oslc.paging", new Object[]{"true"});
            resource.queryParam("oslc.pageSize", new Object[]{this.pageSize});
        }
    }

    private void applyOslcQueryParams(Resource resource) {
        if (this.where != null && !this.where.isEmpty()) {
            resource.queryParam("oslc.where", new Object[]{this.where});
        }
        if (this.select != null && !this.select.isEmpty()) {
            resource.queryParam("oslc.select", new Object[]{this.select});
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            resource.queryParam("oslc.orderBy", new Object[]{this.orderBy});
        }
        if (this.searchTerms != null && !this.searchTerms.isEmpty()) {
            resource.queryParam("oslc.searchTerms", new Object[]{this.searchTerms});
        }
        if (this.prefix != null && !this.prefix.isEmpty()) {
            resource.queryParam("oslc.prefix", new Object[]{this.prefix});
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getCapabilityUrl() {
        return this.capabilityUrl;
    }

    public String getQueryUrl() {
        if (this.queryUrl == null) {
            this.queryUrl = this.queryResource.getUriBuilder().build(new Object[0]).toString();
        }
        return this.queryUrl;
    }

    public OslcQueryResult submit() {
        return new OslcQueryResult(this, this.getResponse());
    }

    ClientResponse getResponse() {
        ClientResponse cr = null;
        if (this.oslcClient instanceof OslcOAuthClient) {
            try {
                cr = this.oslcClient.getResource(this.getQueryUrl(), "application/rdf+xml");
            }
            catch (Exception exception) {}
        } else {
            cr = this.queryResource.get();
        }
        return cr;
    }
}

