/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.client.OAuthResponseMessage;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpMessageDecoder;
import net.oauth.http.HttpResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthClient {
    private HttpClient http;
    protected final Map<String, Object> httpParameters = new HashMap<String, Object>();
    public static final String PARAMETER_STYLE = "parameterStyle";
    @Deprecated
    public static final String ACCEPT_ENCODING = "HTTP.header.Accept-Encoding";
    protected static final String PUT = "PUT";
    protected static final String POST = "POST";
    protected static final String DELETE = "DELETE";
    protected static final String CONTENT_LENGTH = "Content-Length";

    public OAuthClient(HttpClient http) {
        this.http = http;
        this.httpParameters.put("followRedirects", Boolean.FALSE);
    }

    public void setHttpClient(HttpClient http) {
        this.http = http;
    }

    public HttpClient getHttpClient() {
        return this.http;
    }

    public Map<String, Object> getHttpParameters() {
        return this.httpParameters;
    }

    public void getRequestToken(OAuthAccessor accessor) throws IOException, OAuthException, URISyntaxException {
        this.getRequestToken(accessor, null);
    }

    public void getRequestToken(OAuthAccessor accessor, String httpMethod) throws IOException, OAuthException, URISyntaxException {
        this.getRequestToken(accessor, httpMethod, null);
    }

    public void getRequestToken(OAuthAccessor accessor, String httpMethod, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        this.getRequestTokenResponse(accessor, httpMethod, parameters);
    }

    public OAuthMessage getRequestTokenResponse(OAuthAccessor accessor, String httpMethod, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        accessor.accessToken = null;
        accessor.tokenSecret = null;
        Object accessorSecret = accessor.getProperty("oauth_accessor_secret");
        if (accessorSecret != null) {
            ArrayList<? extends Map.Entry> p = parameters == null ? new ArrayList<Map.Entry>(1) : new ArrayList<Map.Entry>(parameters);
            p.add(new OAuth.Parameter("oauth_accessor_secret", accessorSecret.toString()));
            parameters = p;
        }
        OAuthMessage response = this.invoke(accessor, httpMethod, accessor.consumer.serviceProvider.requestTokenURL, parameters);
        accessor.requestToken = response.getParameter("oauth_token");
        accessor.tokenSecret = response.getParameter("oauth_token_secret");
        response.requireParameters("oauth_token", "oauth_token_secret");
        return response;
    }

    public OAuthMessage getAccessToken(OAuthAccessor accessor, String httpMethod, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        if (accessor.requestToken != null) {
            if (parameters == null) {
                parameters = OAuth.newList("oauth_token", accessor.requestToken);
            } else if (!OAuth.newMap(parameters).containsKey("oauth_token")) {
                ArrayList<? extends Map.Entry> p = new ArrayList<Map.Entry>(parameters);
                p.add(new OAuth.Parameter("oauth_token", accessor.requestToken));
                parameters = p;
            }
        }
        OAuthMessage response = this.invoke(accessor, httpMethod, accessor.consumer.serviceProvider.accessTokenURL, parameters);
        response.requireParameters("oauth_token", "oauth_token_secret");
        accessor.accessToken = response.getParameter("oauth_token");
        accessor.tokenSecret = response.getParameter("oauth_token_secret");
        return response;
    }

    public OAuthMessage invoke(OAuthAccessor accessor, String httpMethod, String url, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        Object ps;
        OAuthMessage request = accessor.newRequestMessage(httpMethod, url, parameters);
        Object accepted = accessor.consumer.getProperty(ACCEPT_ENCODING);
        if (accepted != null) {
            request.getHeaders().add(new OAuth.Parameter("Accept-Encoding", accepted.toString()));
        }
        net.oauth.ParameterStyle style = (ps = accessor.consumer.getProperty(PARAMETER_STYLE)) == null ? net.oauth.ParameterStyle.BODY : Enum.valueOf(net.oauth.ParameterStyle.class, ps.toString());
        return this.invoke(request, style);
    }

    public OAuthMessage invoke(OAuthAccessor accessor, String url, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        return this.invoke(accessor, null, url, parameters);
    }

    public OAuthMessage invoke(OAuthMessage request, net.oauth.ParameterStyle style) throws IOException, OAuthException {
        OAuthResponseMessage response = this.access(request, style);
        if (response.getHttpResponse().getStatusCode() / 100 != 2) {
            throw response.toOAuthProblemException();
        }
        return response;
    }

    public OAuthResponseMessage access(OAuthMessage request, net.oauth.ParameterStyle style) throws IOException {
        HttpMessage httpRequest = HttpMessage.newRequest(request, style);
        HttpResponseMessage httpResponse = this.http.execute(httpRequest, this.httpParameters);
        httpResponse = HttpMessageDecoder.decode(httpResponse);
        return new OAuthResponseMessage(httpResponse);
    }

    public OAuthMessage invoke(OAuthMessage request, ParameterStyle style) throws IOException, OAuthException {
        return this.invoke(request, style.getReplacement());
    }

    public OAuthResponseMessage access(OAuthMessage request, ParameterStyle style) throws IOException {
        return this.access(request, style.getReplacement());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParameterStyle {
        AUTHORIZATION_HEADER(net.oauth.ParameterStyle.AUTHORIZATION_HEADER),
        BODY(net.oauth.ParameterStyle.BODY),
        QUERY_STRING(net.oauth.ParameterStyle.QUERY_STRING);

        private final net.oauth.ParameterStyle replacement;

        public net.oauth.ParameterStyle getReplacement() {
            return this.replacement;
        }

        private ParameterStyle(net.oauth.ParameterStyle replacement) {
            this.replacement = replacement;
        }
    }
}

