/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.utils.marshallers;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.lyo.core.utils.marshallers.MarshallerConstants;
import org.eclipse.lyo.core.utils.marshallers.OSLC4JContext;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.oslc4j.provider.json4j.JsonHelper;

public class OSLC4JMarshaller {
    OSLC4JContext context = new OSLC4JContext();
    MediaType mediaType = MarshallerConstants.MT_RDF_XML;

    OSLC4JMarshaller() {
    }

    public void marshal(Object[] resources, OutputStream os) throws WebApplicationException {
        block13: {
            try {
                if (this.mediaType.isCompatible(MarshallerConstants.MT_RDF_XML) || this.mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE) || this.mediaType.isCompatible(MarshallerConstants.MT_N_TRIPLES) || this.mediaType.isCompatible(MarshallerConstants.MT_TURTLE) || this.mediaType.isCompatible(MarshallerConstants.MT_N3)) {
                    Model model = JenaModelHelper.createJenaModel((Object[])resources);
                    if (model != null) {
                        String format = "RDF/XML";
                        if (this.mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                            format = "RDF/XML-ABBREV";
                        } else if (this.mediaType.isCompatible(MarshallerConstants.MT_N_TRIPLES)) {
                            format = "N-TRIPLE";
                        } else if (this.mediaType.isCompatible(MarshallerConstants.MT_TURTLE)) {
                            format = "TURTLE";
                        } else if (this.mediaType.isCompatible(MarshallerConstants.MT_N3)) {
                            format = "N3";
                        }
                        RDFWriter writer = model.getWriter(format);
                        if (this.mediaType.isCompatible(MarshallerConstants.MT_RDF_XML) || this.mediaType.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                            writer.setProperty("showXmlDeclaration", (Object)"true");
                        }
                        writer.write(model, os, null);
                    }
                    break block13;
                }
                if (this.mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
                    JSONObject jo = JsonHelper.createJSON(null, null, null, (Object[])resources, null);
                    jo.write(os);
                    break block13;
                }
                throw new RuntimeException("Unknown Media Type: " + this.mediaType);
            }
            catch (Exception e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

