/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.model.synd;

import java.util.Date;
import org.apache.wink.common.model.synd.SyndBase;
import org.apache.wink.common.model.synd.SyndContent;
import org.apache.wink.common.model.synd.SyndText;

public class SyndEntry
extends SyndBase {
    private SyndText summary;
    private Date published;
    private SyndContent content;

    public SyndEntry() {
    }

    public SyndEntry(String title, String id) {
        this(title, id, null);
    }

    public SyndEntry(SyndText title, String id) {
        this(title, id, null);
    }

    public SyndEntry(String title, String id, Date updated) {
        this(new SyndText(title), id, updated);
    }

    public SyndEntry(SyndText title, String id, Date updated) {
        super(id, title, updated);
    }

    public SyndEntry(SyndEntry other) {
        super(other);
        this.summary = new SyndText(other.summary);
        this.published = other.published != null ? new Date(other.published.getTime()) : null;
        this.content = new SyndContent(other.content);
    }

    public SyndText getSummary() {
        return this.summary;
    }

    public void setSummary(SyndText summary) {
        this.summary = summary;
    }

    public Date getPublished() {
        return this.published;
    }

    public void setPublished(Date published) {
        this.published = published;
    }

    public SyndContent getContent() {
        return this.content;
    }

    public void setContent(SyndContent content) {
        this.content = content;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.published == null ? 0 : this.published.hashCode());
        result = 31 * result + (this.summary == null ? 0 : this.summary.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyndEntry other = (SyndEntry)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.published == null ? other.published != null : !this.published.equals(other.published)) {
            return false;
        }
        return !(this.summary == null ? other.summary != null : !this.summary.equals(other.summary));
    }
}

