/*
 * Decompiled with CFR 0.152.
 */
package jena;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinException;
import com.hp.hpl.jena.reasoner.rulesys.BuiltinRegistry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jena.cmdline.Arg;
import jena.cmdline.CmdLineUtils;
import jena.cmdline.CommandLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleMap {
    public static List<Rule> loadRules(String filename, Map<String, String> prefixes) throws IOException {
        String fname = filename;
        if (fname.startsWith("file:///")) {
            fname = File.separator + fname.substring(8);
        } else if (fname.startsWith("file:/")) {
            fname = File.separator + fname.substring(6);
        } else if (fname.startsWith("file:")) {
            fname = fname.substring(5);
        }
        BufferedReader src = FileUtils.openResourceFile(fname);
        return RuleMap.loadRules(src, prefixes);
    }

    public static List<Rule> loadRules(BufferedReader src, Map<String, String> prefixes) throws IOException {
        Rule.Parser parser = Rule.rulesParserFromReader(src);
        List<Rule> rules = Rule.parseRules(parser);
        prefixes.putAll(parser.getPrefixMap());
        return rules;
    }

    public static void main(String[] args) {
        try {
            Arg il;
            CommandLine cl = new CommandLine();
            String usage = "Usage:  RuleMap [-il inlang] [-ol outlang] [-d] rulefile infile (- for stdin)";
            cl.setUsage(usage);
            cl.add("il", true);
            cl.add("ol", true);
            cl.add("d", false);
            cl.process(args);
            if (cl.numItems() != 2) {
                System.err.println(usage);
                System.exit(1);
            }
            String inLang = (il = cl.getArg("il")) == null ? null : il.getValue();
            String fname = cl.getItem(1);
            Model inModel = null;
            if (fname.equals("-")) {
                inModel = ModelFactory.createDefaultModel();
                inModel.read(System.in, null, inLang);
            } else {
                inModel = FileManager.get().loadModel(fname, inLang);
            }
            Arg ol = cl.getArg("ol");
            String outLang = ol == null ? "N3" : ol.getValue();
            Arg d = cl.getArg("d");
            boolean deductionsOnly = d != null;
            BuiltinRegistry.theRegistry.register(new Deduce());
            HashMap<String, String> prefixes = new HashMap<String, String>();
            List<Rule> rules = RuleMap.loadRules(cl.getItem(0), prefixes);
            GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
            InfModel infModel = ModelFactory.createInfModel(reasoner, inModel);
            infModel.prepare();
            infModel.setNsPrefixes(prefixes);
            PrintWriter writer = new PrintWriter(System.out);
            if (deductionsOnly) {
                Model deductions = infModel.getDeductionsModel();
                deductions.setNsPrefixes(prefixes);
                deductions.setNsPrefixes(inModel);
                deductions.write(writer, outLang);
            } else {
                infModel.write(writer, outLang);
            }
            writer.close();
        }
        catch (Throwable t) {
            System.err.println("An error occured: \n" + t);
            t.printStackTrace();
        }
    }

    static {
        CmdLineUtils.setLog4jConfiguration();
    }

    static class Deduce
    extends BaseBuiltin {
        Deduce() {
        }

        public String getName() {
            return "deduce";
        }

        public int getArgLength() {
            return 3;
        }

        public void headAction(Node[] args, int length, RuleContext context) {
            if (!(context.getGraph() instanceof FBRuleInfGraph)) {
                throw new BuiltinException(this, context, "Only usable in FBrule graphs");
            }
            Triple t = new Triple(args[0], args[1], args[2]);
            ((FBRuleInfGraph)context.getGraph()).addDeduction(t);
        }
    }
}

