/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.client.oslc.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.client.oslc.resources.RequirementCollection;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/rm#")
@OslcResourceShape(title="Requirement Resource Shape", describes={"http://open-services.net/ns/rm#Requirement"})
public class Requirement
extends AbstractResource {
    private String title;
    private String description;
    private String identifier;
    private String shortTitle;
    private final Set<String> subjects = new TreeSet<String>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<URI> contributors = new TreeSet<URI>();
    private Date created;
    private Date modified;
    private final Set<URI> rdfTypes = new TreeSet<URI>();
    private URI serviceProvider;
    private URI instanceShape;
    private final Set<Link> elaboratedBy = new HashSet<Link>();
    private final Set<Link> elaborates = new HashSet<Link>();
    private final Set<Link> specifiedBy = new HashSet<Link>();
    private final Set<Link> specifies = new HashSet<Link>();
    private final Set<Link> affectedBy = new HashSet<Link>();
    private final Set<Link> trackedBy = new HashSet<Link>();
    private final Set<Link> implementedBy = new HashSet<Link>();
    private final Set<Link> validatedBy = new HashSet<Link>();
    private final Set<Link> satisfiedBy = new HashSet<Link>();
    private final Set<Link> satisfies = new HashSet<Link>();
    private final Set<Link> decomposedBy = new HashSet<Link>();
    private final Set<Link> decomposes = new HashSet<Link>();
    private final Set<Link> constrainedBy = new HashSet<Link>();
    private final Set<Link> constrains = new HashSet<Link>();

    public Requirement() throws URISyntaxException {
        if (!(this instanceof RequirementCollection)) {
            this.rdfTypes.add(new URI("http://open-services.net/ns/rm#Requirement"));
        }
    }

    public Requirement(URI about) throws URISyntaxException {
        super(about);
        if (!(this instanceof RequirementCollection)) {
            this.rdfTypes.add(new URI("http://open-services.net/ns/rm#Requirement"));
        }
    }

    public void addSubject(String subject) {
        this.subjects.add(subject);
    }

    public void addConstrains(Link constrains) {
        this.constrains.add(constrains);
    }

    public void addConstrainedBy(Link constrainedBy) {
        this.constrainedBy.add(constrainedBy);
    }

    public void addDecomposes(Link decomposes) {
        this.decomposes.add(decomposes);
    }

    public void addDecomposedBy(Link decomposedBy) {
        this.decomposedBy.add(decomposedBy);
    }

    public void addSatisfies(Link satisfies) {
        this.satisfies.add(satisfies);
    }

    public void addSatisfiedBy(Link satisfiedBy) {
        this.satisfiedBy.add(satisfiedBy);
    }

    public void addValidatedBy(Link validatedBy) {
        this.validatedBy.add(validatedBy);
    }

    public void addTrackedBy(Link trackedBy) {
        this.trackedBy.add(trackedBy);
    }

    public void addImplementedBy(Link implementedBy) {
        this.implementedBy.add(implementedBy);
    }

    public void addAffectedBy(Link affectedBy) {
        this.affectedBy.add(affectedBy);
    }

    public void addElaboratedBy(Link elaboratedBy) {
        this.elaboratedBy.add(elaboratedBy);
    }

    public void addElaborates(Link elaborates) {
        this.elaborates.add(elaborates);
    }

    public void addSpecifiedBy(Link specifiedBy) {
        this.specifiedBy.add(specifiedBy);
    }

    public void addSpecifies(Link specifies) {
        this.specifies.add(specifies);
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRdfType(URI rdfType) {
        this.rdfTypes.add(rdfType);
    }

    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcReadOnly(value=false)
    @OslcTitle(value="Subjects")
    public String[] getSubjects() {
        return this.subjects.toArray(new String[this.subjects.size()]);
    }

    @OslcDescription(value="The subject is elaborated by the object.")
    @OslcName(value="elaboratedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#elaboratedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Elaborated By")
    public Link[] getElaboratedBy() {
        return this.elaboratedBy.toArray(new Link[this.elaboratedBy.size()]);
    }

    @OslcDescription(value="The object is elaborated by the subject.")
    @OslcName(value="elaborates")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#elaborates")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Elaborates")
    public Link[] getElaborates() {
        return this.elaborates.toArray(new Link[this.elaborates.size()]);
    }

    @OslcDescription(value="The subject is specified by the object.")
    @OslcName(value="specifiedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#specifiedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Specified By")
    public Link[] getSpecifiedBy() {
        return this.specifiedBy.toArray(new Link[this.specifiedBy.size()]);
    }

    @OslcDescription(value="The object is specified by the subject.")
    @OslcName(value="specifies")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#specifies")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Specifies")
    public Link[] getSpecifies() {
        return this.specifies.toArray(new Link[this.specifies.size()]);
    }

    @OslcDescription(value="Resource, such as a change request, which implements this requirement.")
    @OslcName(value="implementedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#implementedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Implemented By")
    public Link[] getImplementedBy() {
        return this.implementedBy.toArray(new Link[this.implementedBy.size()]);
    }

    @OslcDescription(value="Requirement is affected by a resource, such as a defect or issue.")
    @OslcName(value="affectedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#affectedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Affected By")
    public Link[] getAffectedBy() {
        return this.affectedBy.toArray(new Link[this.affectedBy.size()]);
    }

    @OslcDescription(value="Resource, such as a change request, which tracks this requirement.")
    @OslcName(value="trackedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#trackedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="tracked By")
    public Link[] getTrackedBy() {
        return this.trackedBy.toArray(new Link[this.trackedBy.size()]);
    }

    @OslcDescription(value="Resource, such as a test case, which validates this requirement.")
    @OslcName(value="validatedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#validatedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Validated By")
    public Link[] getValidatedBy() {
        return this.validatedBy.toArray(new Link[this.validatedBy.size()]);
    }

    @OslcDescription(value="The subject is satisfied by the object.")
    @OslcName(value="satisfiedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#satisfiedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Satisfied By")
    public Link[] getSatisfiedBy() {
        return this.satisfiedBy.toArray(new Link[this.satisfiedBy.size()]);
    }

    @OslcDescription(value="The object is satisfied by the subject.")
    @OslcName(value="satisfies")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#satisfies")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Satisfies")
    public Link[] getSatisfies() {
        return this.satisfies.toArray(new Link[this.satisfies.size()]);
    }

    @OslcDescription(value="The subject is decomposed by the object.")
    @OslcName(value="decomposedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#decomposedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="DecomposedBy")
    public Link[] getDecomposedBy() {
        return this.decomposedBy.toArray(new Link[this.decomposedBy.size()]);
    }

    @OslcDescription(value="The object is decomposed by the subject.")
    @OslcName(value="decomposes")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#decomposes")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Decomposes")
    public Link[] getDecomposes() {
        return this.decomposes.toArray(new Link[this.decomposes.size()]);
    }

    @OslcDescription(value="The subject is constrained by the object.")
    @OslcName(value="constrainedBy")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#constrainedBy")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="ConstrainedBy")
    public Link[] getConstrainedBy() {
        return this.constrainedBy.toArray(new Link[this.constrainedBy.size()]);
    }

    @OslcDescription(value="The object is constrained by the subject.")
    @OslcName(value="constrains")
    @OslcPropertyDefinition(value="http://open-services.net/ns/rm#constrains")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Constrains")
    public Link[] getConstrains() {
        return this.constrains.toArray(new Link[this.constrains.size()]);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the change request.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Timestamp of resource creation.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcReadOnly
    @OslcTitle(value="Created")
    public Date getCreated() {
        return this.created;
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="A unique identifier for a resource. Assigned by the service provider when a resource is created. Not intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcTitle(value="Identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcTitle(value="Instance Shape")
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    @OslcDescription(value="Timestamp last latest resource modification.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcReadOnly
    @OslcTitle(value="Modified")
    public Date getModified() {
        return this.modified;
    }

    @OslcDescription(value="The resource type URIs.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Types")
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcTitle(value="Service Provider")
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    @OslcDescription(value="Short name identifying a resource, often used as an abbreviated identifier for presentation to end-users.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#shortTitle")
    @OslcTitle(value="Short Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getShortTitle() {
        return this.shortTitle;
    }

    @OslcDescription(value="Title (reference: Dublin Core) or often a single line summary of the resource represented as rich text in XHTML content.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    public void setConstrains(Link[] constrains) {
        this.constrains.clear();
        if (constrains != null) {
            this.constrains.addAll(Arrays.asList(constrains));
        }
    }

    public void setConstrainedBy(Link[] constrainedBy) {
        this.constrainedBy.clear();
        if (constrainedBy != null) {
            this.constrainedBy.addAll(Arrays.asList(constrainedBy));
        }
    }

    public void setDecomposes(Link[] decomposes) {
        this.affectedBy.clear();
        if (decomposes != null) {
            this.decomposes.addAll(Arrays.asList(decomposes));
        }
    }

    public void setDecomposedBy(Link[] decomposedBy) {
        this.decomposedBy.clear();
        if (decomposedBy != null) {
            this.decomposedBy.addAll(Arrays.asList(decomposedBy));
        }
    }

    public void setSatisfies(Link[] satisfies) {
        this.satisfies.clear();
        if (satisfies != null) {
            this.satisfies.addAll(Arrays.asList(satisfies));
        }
    }

    public void setSatisfiedBy(Link[] satisfiedBy) {
        this.satisfiedBy.clear();
        if (satisfiedBy != null) {
            this.satisfiedBy.addAll(Arrays.asList(satisfiedBy));
        }
    }

    public void setValidatedBy(Link[] validatedBy) {
        this.validatedBy.clear();
        if (validatedBy != null) {
            this.validatedBy.addAll(Arrays.asList(validatedBy));
        }
    }

    public void setTrackedBy(Link[] trackedBy) {
        this.trackedBy.clear();
        if (trackedBy != null) {
            this.trackedBy.addAll(Arrays.asList(trackedBy));
        }
    }

    public void setAffectedBy(Link[] affectedBy) {
        this.affectedBy.clear();
        if (affectedBy != null) {
            this.affectedBy.addAll(Arrays.asList(affectedBy));
        }
    }

    public void setImplementedBy(Link[] implementedBy) {
        this.implementedBy.clear();
        if (implementedBy != null) {
            this.implementedBy.addAll(Arrays.asList(implementedBy));
        }
    }

    public void setElaboratedBy(Link[] elaboratedBy) {
        this.elaboratedBy.clear();
        if (elaboratedBy != null) {
            this.elaboratedBy.addAll(Arrays.asList(elaboratedBy));
        }
    }

    public void setElaborates(Link[] elaborates) {
        this.elaborates.clear();
        if (elaborates != null) {
            this.elaborates.addAll(Arrays.asList(elaborates));
        }
    }

    public void setSpecifiedBy(Link[] specifiedBy) {
        this.specifiedBy.clear();
        if (specifiedBy != null) {
            this.specifiedBy.addAll(Arrays.asList(specifiedBy));
        }
    }

    public void setSpecifies(Link[] specifies) {
        this.specifies.clear();
        if (specifies != null) {
            this.specifies.addAll(Arrays.asList(specifies));
        }
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    public void setServiceProvider(URI serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setShortTitle(String shortTitle) {
        this.shortTitle = shortTitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubjects(String[] subjects) {
        this.subjects.clear();
        if (subjects != null) {
            this.subjects.addAll(Arrays.asList(subjects));
        }
    }
}

