/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.lyo.core.query.ScopedSortTerm;
import org.eclipse.lyo.core.query.SimpleSortTerm;
import org.eclipse.lyo.core.query.SortTerm;
import org.eclipse.lyo.core.query.impl.ScopedSortTermInvocationHandler;
import org.eclipse.lyo.core.query.impl.SimpleSortTermInvocationHandler;

public class SortTermsInvocationHandler
implements InvocationHandler {
    private final CommonTree tree;
    private final Map<String, String> prefixMap;
    private List<SortTerm> children = null;

    public SortTermsInvocationHandler(CommonTree tree, Map<String, String> prefixMap) {
        this.tree = tree;
        this.prefixMap = prefixMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.children == null) {
            List rawChildren = this.tree.getChildren();
            this.children = new ArrayList<SortTerm>(rawChildren.size());
            for (CommonTree child : rawChildren) {
                Object simpleTerm;
                switch (child.getToken().getType()) {
                    case 6: {
                        simpleTerm = Proxy.newProxyInstance(SimpleSortTerm.class.getClassLoader(), new Class[]{SimpleSortTerm.class}, (InvocationHandler)new SimpleSortTermInvocationHandler(child, this.prefixMap));
                        break;
                    }
                    case 5: {
                        simpleTerm = Proxy.newProxyInstance(ScopedSortTerm.class.getClassLoader(), new Class[]{ScopedSortTerm.class}, (InvocationHandler)new ScopedSortTermInvocationHandler(child, this.prefixMap));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unimplemented type of sort term: " + child.getToken().getText());
                    }
                }
                this.children.add((SortTerm)simpleTerm);
            }
            this.children = Collections.unmodifiableList(this.children);
        }
        if (method.getName().equals("children")) {
            return this.children;
        }
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        for (SortTerm term : this.children) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(term.toString());
        }
        return buffer.toString();
    }
}

