/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.Method;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.lyo.core.query.PName;
import org.eclipse.lyo.core.query.TypedValue;
import org.eclipse.lyo.core.query.Value;
import org.eclipse.lyo.core.query.impl.ValueInvocationHandler;

class TypedValueInvocationHandler
extends ValueInvocationHandler {
    private final Map<String, String> prefixMap;
    private String value = null;
    private PName prefixedName = null;

    public TypedValueInvocationHandler(CommonTree tree, Map<String, String> prefixMap) {
        super(tree, Value.Type.TYPED_STRING);
        this.prefixMap = prefixMap;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        boolean isValue = methodName.equals("value");
        if (!(isValue || methodName.equals("prefixedName") || methodName.equals("toString"))) {
            return super.invoke(proxy, method, args);
        }
        if (isValue) {
            if (this.value == null) {
                String rawValue = ((CommonTree)this.tree.getChild(0)).getText();
                this.value = rawValue.substring(1, rawValue.length() - 1);
            }
            return this.value;
        }
        if (this.prefixedName == null) {
            String rawPName = this.tree.getChild(1).getText();
            this.prefixedName = new PName();
            int colon = rawPName.indexOf(58);
            if (colon < 0) {
                this.prefixedName.local = rawPName;
            } else {
                if (colon > 0) {
                    this.prefixedName.prefix = rawPName.substring(0, colon);
                    this.prefixedName.namespace = this.prefixMap.get(this.prefixedName.prefix);
                }
                this.prefixedName.local = rawPName.substring(colon + 1);
            }
        }
        if (methodName.equals("prefixedName")) {
            return this.prefixedName;
        }
        return '\"' + ((TypedValue)proxy).value() + "\"^^" + ((TypedValue)proxy).prefixedName();
    }
}

