/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.eclipse.lyo.oslc4j.core.model.Property;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.XMLLiteral;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSLC4JUtils {
    private static String publicURI = System.getProperty("org.eclipse.lyo.oslc4j.publicURI");
    private static String useBeanClassForParsing = System.getProperty("org.eclipse.lyo.oslc4j.useBeanClassForParsing");
    private static String inferTypeFromShape = System.getProperty("org.eclipse.lyo.oslc4j.inferTypeFromResourceShape");
    private static List<ResourceShape> shapes = new ArrayList<ResourceShape>();
    private static final Logger logger = Logger.getLogger(OSLC4JUtils.class.getName());

    public static String getPublicURI() {
        return publicURI;
    }

    public static void setPublicURI(String newPublicURI) throws MalformedURLException {
        if (newPublicURI != null && !newPublicURI.isEmpty()) {
            URL uRL = new URL(newPublicURI);
        }
        publicURI = newPublicURI;
    }

    public static boolean useBeanClassForParsing() {
        boolean result = false;
        if (null != useBeanClassForParsing) {
            result = Boolean.parseBoolean(useBeanClassForParsing);
        }
        return result;
    }

    public static String getUseBeanClassForParsing() {
        return useBeanClassForParsing;
    }

    public static void setUseBeanClassForParsing(String useBeanClassForParsing) {
        OSLC4JUtils.useBeanClassForParsing = useBeanClassForParsing;
    }

    public static boolean inferTypeFromShape() {
        boolean result = false;
        if (null != inferTypeFromShape) {
            result = Boolean.parseBoolean(inferTypeFromShape);
        }
        return result;
    }

    public static String getInferTypeFromShape() {
        return inferTypeFromShape;
    }

    public static void setInferTypeFromShape(String inferTypeFromShape) {
        OSLC4JUtils.inferTypeFromShape = inferTypeFromShape;
    }

    public static List<ResourceShape> getShapes() {
        return shapes;
    }

    public static void setShapes(List<ResourceShape> shapes) {
        OSLC4JUtils.shapes = shapes;
    }

    public static boolean isHostResolutionDisabled() {
        boolean retVal = false;
        String hostResDisabledProp = System.getProperty("org.eclipse.lyo.oslc4j.disableHostResolution");
        if (hostResDisabledProp != null) {
            retVal = Boolean.parseBoolean(hostResDisabledProp);
        }
        return retVal;
    }

    public static void setHostResolutionDisabled(boolean hostResDisabled) {
        System.setProperty("org.eclipse.lyo.oslc4j.disableHostResolution", Boolean.toString(hostResDisabled));
    }

    public static String resolveURI(HttpServletRequest request, boolean includePath) {
        UriBuilder builder = null;
        String pathInfo = request.getPathInfo();
        String servletPath = request.getServletPath();
        String configuredPublicURI = OSLC4JUtils.getPublicURI();
        if (configuredPublicURI != null && !configuredPublicURI.isEmpty()) {
            String uriToBuild = includePath ? configuredPublicURI + "/" + servletPath + pathInfo : configuredPublicURI;
            builder = UriBuilder.fromUri((String)uriToBuild);
        } else {
            String hostName = "localhost";
            boolean getHostNameFromRequest = false;
            if (OSLC4JUtils.isHostResolutionDisabled()) {
                getHostNameFromRequest = true;
            } else {
                try {
                    hostName = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    logger.finer("Unable to resolve hostname.  Extracting hostname from request.");
                    getHostNameFromRequest = true;
                }
            }
            if (getHostNameFromRequest) {
                hostName = request.getServerName();
            }
            String contextPath = request.getContextPath();
            String pathToBuild = includePath ? contextPath + servletPath + pathInfo : contextPath;
            builder = UriBuilder.fromPath((String)pathToBuild).scheme(request.getScheme()).host(hostName).port(request.getServerPort());
        }
        URI resolvedURI = builder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }

    public static boolean relativeURIsAreDisabled() {
        boolean retVal = true;
        String relURIsDisabledProp = System.getProperty("org.eclipse.lyo.oslc4j.disableRelativeURIs");
        if (relURIsDisabledProp != null) {
            retVal = Boolean.parseBoolean(relURIsDisabledProp);
        }
        return retVal;
    }

    public static boolean isQueryResultListAsContainer() {
        return "true".equals(System.getProperty("org.eclipse.lyo.oslc4j.queryResultListAsContainer", "false"));
    }

    private static boolean doesResourceShapeMatchRdfTypes(ResourceShape shape, HashSet<String> rdfTypesList) {
        if (null != shape) {
            URI[] describes;
            for (URI describeUri : describes = shape.getDescribes()) {
                String describeUriStr = describeUri.toASCIIString();
                if (!rdfTypesList.contains(describeUriStr)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getValueBasedOnResourceShapeType(HashSet<String> rdfTypesList, QName propertyQName, Object originalValue) throws DatatypeConfigurationException, IllegalArgumentException, InstantiationException, InvocationTargetException {
        if (null != rdfTypesList && !rdfTypesList.isEmpty() && null != propertyQName && null != originalValue) {
            try {
                List<ResourceShape> shapes = OSLC4JUtils.getShapes();
                if (null != shapes && !shapes.isEmpty()) {
                    String propertyName = propertyQName.getNamespaceURI() + propertyQName.getLocalPart();
                    TypeMapper typeMapper = TypeMapper.getInstance();
                    for (ResourceShape shape : shapes) {
                        Property[] props;
                        if (!OSLC4JUtils.doesResourceShapeMatchRdfTypes(shape, rdfTypesList)) continue;
                        for (Property prop : props = shape.getProperties()) {
                            RDFDatatype dataTypeFromShape;
                            URI propValueType;
                            URI propDefinition = prop.getPropertyDefinition();
                            if (!propertyName.equals(propDefinition.toString()) || null == (propValueType = prop.getValueType()) || null == (dataTypeFromShape = typeMapper.getTypeByName(propValueType.toString()))) continue;
                            try {
                                if (XMLLiteralType.theXMLLiteralType.getURI().equals(propValueType.toString())) {
                                    return new XMLLiteral(originalValue.toString());
                                }
                                Class objClass = dataTypeFromShape.getJavaClass();
                                if (objClass.getCanonicalName().equals(XSDDateTime.class.getCanonicalName())) {
                                    String dateStr = originalValue.toString();
                                    GregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateStr).toGregorianCalendar();
                                    XSDDateTime xsdDateTime = new XSDDateTime((Calendar)calendar);
                                    return xsdDateTime.asCalendar().getTime();
                                }
                                if (objClass.getCanonicalName().equals(Boolean.class.getCanonicalName())) {
                                    if (Boolean.TRUE.toString().equals(originalValue.toString()) || "1".equals(originalValue.toString())) {
                                        return Boolean.TRUE;
                                    }
                                    if (Boolean.FALSE.toString().equals(originalValue.toString()) || "0".equals(originalValue.toString())) {
                                        return Boolean.FALSE;
                                    }
                                    throw new IllegalArgumentException("'" + originalValue.toString() + "' has wrong format for Boolean.");
                                }
                                if (objClass.getCanonicalName().equals(Double.class.getCanonicalName())) {
                                    return XSDDatatype.XSDdouble.parseValidated(originalValue.toString());
                                }
                                if (objClass.getCanonicalName().equals(Float.class.getCanonicalName())) {
                                    return XSDDatatype.XSDfloat.parseValidated(originalValue.toString());
                                }
                                Constructor cons = objClass.getConstructor(String.class);
                                return cons.newInstance(originalValue.toString());
                            }
                            catch (IllegalArgumentException e) {
                                String errorMessage = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
                                throw new IllegalArgumentException(errorMessage, e);
                            }
                            catch (InvocationTargetException e) {
                                String errorMessage = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
                                throw new IllegalArgumentException(errorMessage, e);
                            }
                            catch (DatatypeFormatException e) {
                                String errorMessage = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
                                throw new IllegalArgumentException(errorMessage, e);
                            }
                        }
                    }
                }
            }
            catch (NoSuchMethodException e) {
                logger.warning("Could not create extended value <" + propertyQName + " +> based on shape: " + e.getLocalizedMessage());
                return null;
            }
            catch (IllegalAccessException e) {
                logger.warning("Could not create extended value <" + propertyQName + " +> based on shape: " + e.getLocalizedMessage());
                return null;
            }
        }
        return null;
    }
}

