/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptCharset {
    private static final RuntimeDelegate.HeaderDelegate<AcceptCharset> delegate = RuntimeDelegate.getInstance().createHeaderDelegate(AcceptCharset.class);
    private final String acceptCharsetHeader;
    private final boolean anyAllowed;
    private final List<String> acceptable;
    private final List<String> banned;
    private final List<ValuedCharset> valuedCharsets;

    public AcceptCharset(String acceptCharset, List<String> acceptableCharsets, List<String> bannedCharsets, boolean anyCharsetAllowed, List<ValuedCharset> valuedCharsets) {
        this.acceptCharsetHeader = acceptCharset;
        this.anyAllowed = anyCharsetAllowed;
        this.banned = Collections.unmodifiableList(bannedCharsets);
        boolean isISO8859Explicit = false;
        for (ValuedCharset vCharset : valuedCharsets) {
            if (!"ISO-8859-1".equalsIgnoreCase(vCharset.charset)) continue;
            isISO8859Explicit = true;
            break;
        }
        if (!isISO8859Explicit && !this.anyAllowed) {
            ArrayList<String> acceptableCharsetsTemp = new ArrayList<String>(acceptableCharsets);
            acceptableCharsetsTemp.add(0, "ISO-8859-1");
            this.acceptable = Collections.unmodifiableList(acceptableCharsetsTemp);
            ArrayList<ValuedCharset> valuedCharsetsTemp = new ArrayList<ValuedCharset>(valuedCharsets);
            valuedCharsetsTemp.add(0, new ValuedCharset(1.0, "ISO-8859-1"));
            this.valuedCharsets = Collections.unmodifiableList(valuedCharsetsTemp);
        } else {
            this.acceptable = Collections.unmodifiableList(acceptableCharsets);
            this.valuedCharsets = Collections.unmodifiableList(valuedCharsets);
        }
    }

    public List<String> getAcceptableCharsets() {
        return this.acceptable;
    }

    public boolean isAnyCharsetAllowed() {
        return this.anyAllowed;
    }

    public List<String> getBannedCharsets() {
        return this.banned;
    }

    public static AcceptCharset valueOf(String value) throws IllegalArgumentException {
        return (AcceptCharset)delegate.fromString(value);
    }

    public String getAcceptCharsetHeader() {
        return this.acceptCharsetHeader;
    }

    public List<ValuedCharset> getValuedCharsets() {
        return this.valuedCharsets;
    }

    public String toString() {
        return delegate.toString((Object)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ValuedCharset
    implements Comparable<ValuedCharset> {
        public final double qValue;
        public final String charset;

        public ValuedCharset(double qValue, String charset) {
            this.qValue = qValue;
            this.charset = charset;
        }

        @Override
        public int compareTo(ValuedCharset other) {
            return Double.compare(this.qValue, other.qValue);
        }

        public boolean isWildcard() {
            return this.charset == null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ValuedCharset)) {
                return false;
            }
            ValuedCharset other = (ValuedCharset)obj;
            if (other.qValue != this.qValue) {
                return false;
            }
            return !(this.charset == null ? other.charset != null : !this.charset.equals(other.charset));
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + Double.valueOf(this.qValue).hashCode();
            result = 31 * result + this.charset.hashCode();
            return result;
        }

        public String toString() {
            return this.charset + ";q=" + this.qValue;
        }
    }
}

