/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.utils;

import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.model.synd.SyndLink;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.ResourceRecord;
import org.apache.wink.server.internal.registry.SubResourceInstance;
import org.apache.wink.server.internal.utils.AbstractLinksBuilderImpl;
import org.apache.wink.server.utils.SystemLinksBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemLinksBuilderImpl
extends AbstractLinksBuilderImpl<SystemLinksBuilder>
implements SystemLinksBuilder {
    private SystemLinksBuilder.LinkType[] types = null;
    private boolean allResources = this.isContinuedSearchMode();

    public SystemLinksBuilderImpl(MessageContext context) {
        super(context);
    }

    protected boolean isContinuedSearchMode() {
        return Boolean.valueOf(this.context.getProperties().getProperty("wink.searchPolicyContinuedSearch", "false"));
    }

    @Override
    public SystemLinksBuilder types(SystemLinksBuilder.LinkType ... types) {
        this.types = types;
        return this;
    }

    @Override
    public SystemLinksBuilder allResources(boolean all) {
        this.allResources = all;
        return this;
    }

    @Override
    public List<SyndLink> build(List<SyndLink> out) {
        HashSet<SyndLink> set = new HashSet<SyndLink>();
        if (this.allResources) {
            URI uri = UriBuilder.fromPath((String)this.resourcePath).buildFromEncodedMap(this.pathParams);
            String path = uri.toString();
            List<ResourceInstance> rootResources = this.registry.getMatchingRootResources(path);
            for (ResourceInstance rootResource : rootResources) {
                UriBuilder uriBuilder = this.initUriBuilder(path);
                ResourceRecord record = rootResource.getRecord();
                this.build(set, uriBuilder, record);
            }
        } else {
            UriBuilder uriBuilder = this.initUriBuilder();
            this.build(set, uriBuilder, this.record);
        }
        if (out == null) {
            out = new LinkedList<SyndLink>();
        }
        out.addAll(set);
        return out;
    }

    private Set<SyndLink> build(Set<SyndLink> set, UriBuilder selfUriBuilder, ResourceRecord record) {
        LinkedList<MethodMetadata> methods = null;
        if (this.subResourcePath != null && this.subResourcePath.length() > 0) {
            List<SubResourceInstance> subResources = record.getMatchingSubResourceMethods(this.subResourcePath);
            methods = new LinkedList<MethodMetadata>();
            for (SubResourceInstance sub : subResources) {
                methods.add(sub.getMetadata());
            }
            selfUriBuilder.path(this.subResourcePath);
        } else {
            methods = record.getMetadata().getResourceMethods();
        }
        return this.build(set, selfUriBuilder, (List<MethodMetadata>)methods);
    }

    private Set<SyndLink> build(Set<SyndLink> set, UriBuilder selfUriBuilder, List<MethodMetadata> methods) {
        for (String query : this.queryParams.keySet()) {
            selfUriBuilder.queryParam(query, ((List)this.queryParams.get((Object)query)).toArray());
        }
        Set<SystemLinksBuilder.LinkType> systemLinksToGenerate = this.generateSystemLinksSet();
        URI selfUri = selfUriBuilder.buildFromEncodedMap(this.pathParams);
        if (systemLinksToGenerate.contains((Object)SystemLinksBuilder.LinkType.SELF) && this.getLink(set, "self") == null) {
            set.add(this.createLink("self", null, selfUri));
        }
        if (systemLinksToGenerate.contains((Object)SystemLinksBuilder.LinkType.EDIT) && this.getLink(set, "edit") == null) {
            for (MethodMetadata methodRecord : methods) {
                String httpMethod = methodRecord.getHttpMethod();
                if (!httpMethod.equalsIgnoreCase("PUT") && !httpMethod.equalsIgnoreCase("DELETE")) continue;
                set.add(this.createLink("edit", null, selfUri));
                break;
            }
        }
        Set<MediaType> producedTypesForGet = SystemLinksBuilderImpl.getProducedTypesForGet(methods);
        for (MediaType mediaType : producedTypesForGet) {
            if (this.addAltParam && this.queryParams.get((Object)"alt") == null) {
                selfUriBuilder.replaceQueryParam("alt", new Object[]{MediaTypeUtils.toEncodedString((MediaType)mediaType)});
            }
            URI href = selfUriBuilder.buildFromEncodedMap(this.pathParams);
            if (MediaTypeUtils.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaTypeUtils.OPENSEARCH_TYPE)) {
                if (!systemLinksToGenerate.contains((Object)SystemLinksBuilder.LinkType.OPENSEARCH)) continue;
                set.add(this.createLink("search", mediaType, href));
                continue;
            }
            if (!systemLinksToGenerate.contains((Object)SystemLinksBuilder.LinkType.ALTERNATE)) continue;
            set.add(this.createLink("alternate", mediaType, href));
        }
        return set;
    }

    private static Set<MediaType> getProducedTypesForGet(List<MethodMetadata> methods) {
        LinkedHashSet<MediaType> getResponses = new LinkedHashSet<MediaType>();
        if (methods != null) {
            for (MethodMetadata methodRecord : methods) {
                if (!methodRecord.getHttpMethod().equals("GET")) continue;
                getResponses.addAll(methodRecord.getProduces());
            }
        }
        return getResponses;
    }

    private Set<SystemLinksBuilder.LinkType> generateSystemLinksSet() {
        HashSet<SystemLinksBuilder.LinkType> systemLinksSet = new HashSet<SystemLinksBuilder.LinkType>();
        if (this.types == null || this.types.length == 0) {
            for (SystemLinksBuilder.LinkType type : SystemLinksBuilder.LinkType.values()) {
                systemLinksSet.add(type);
            }
        } else {
            for (SystemLinksBuilder.LinkType type : this.types) {
                systemLinksSet.add(type);
            }
        }
        return systemLinksSet;
    }
}

