/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriInfo;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.server.internal.registry.MethodRecord;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.SubResourceLocatorRecord;
import org.apache.wink.server.internal.registry.SubResourceMethodRecord;

public class SearchResult {
    private boolean found;
    private WebApplicationException error;
    private ResourceInstance resource;
    private MethodRecord method;
    private Object[] invocationParameters;
    private AccumulatedData data;
    private UriInfo uriInfo;

    public String toString() {
        return String.format("Found: %s, Resource: %s, Method: %s, Error: %s", this.found, this.resource, this.method, this.error);
    }

    public SearchResult(ResourceInstance resource, UriInfo uriInfo) {
        this(false);
        this.uriInfo = uriInfo;
        this.getData().getMatchedResources().addFirst(resource);
    }

    public SearchResult(WebApplicationException error) {
        this(false);
        this.error = error;
    }

    private SearchResult(boolean found) {
        this.found = found;
        this.error = null;
        this.uriInfo = null;
    }

    public ResourceInstance getResource() {
        if (this.getData().getMatchedResources().isEmpty()) {
            return null;
        }
        return this.getData().getMatchedResources().getFirst();
    }

    public MethodRecord getMethod() {
        return this.method;
    }

    public SearchResult setMethod(MethodRecord method) {
        this.method = method;
        return this;
    }

    public MethodType getMethodType() {
        if (this.method instanceof SubResourceMethodRecord) {
            return MethodType.SubResourceMethod;
        }
        if (this.method instanceof SubResourceLocatorRecord) {
            return MethodType.SubResourceLocator;
        }
        return MethodType.ResourceMethod;
    }

    public Object[] getInvocationParameters() {
        return this.invocationParameters;
    }

    public void setInvocationParameters(Object[] invocationParameters) {
        this.invocationParameters = invocationParameters;
    }

    public WebApplicationException getError() {
        return this.error;
    }

    public SearchResult setError(WebApplicationException error) {
        this.error = error;
        if (error != null) {
            this.found = false;
        }
        return this;
    }

    public boolean isError() {
        return this.error != null;
    }

    public SearchResult setFound(boolean found) {
        this.found = found;
        this.error = null;
        return this;
    }

    public boolean isFound() {
        return this.found;
    }

    public AccumulatedData getData() {
        if (this.data == null) {
            this.data = new AccumulatedData(this.uriInfo);
        }
        return this.data;
    }

    public void setData(AccumulatedData data) {
        this.data = data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MethodType {
        ResourceMethod,
        SubResourceMethod,
        SubResourceLocator;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccumulatedData
    implements Cloneable {
        private UriInfo uriInfo;
        private MultivaluedMap<String, String> matchedVariables;
        private MultivaluedMap<String, List<PathSegment>> matchedVariablesPathSegments;
        private LinkedList<List<PathSegment>> matchedURIs;
        private LinkedList<ResourceInstance> matchedResources;

        public AccumulatedData(UriInfo uriInfo) {
            this.uriInfo = uriInfo;
        }

        public AccumulatedData clone() {
            AccumulatedData clone;
            try {
                clone = (AccumulatedData)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            clone.matchedVariables = MultivaluedMapImpl.clone(this.getMatchedVariables());
            clone.matchedVariablesPathSegments = MultivaluedMapImpl.clone(this.getMatchedVariablesPathSegments());
            clone.matchedURIs = (LinkedList)this.getMatchedURIs().clone();
            clone.matchedResources = (LinkedList)this.getMatchedResources().clone();
            return clone;
        }

        public void setMatchedVariables(MultivaluedMap<String, String> matchedVariables) {
            this.matchedVariables = matchedVariables;
        }

        public void setMatchedURIs(LinkedList<List<PathSegment>> matchedURIs) {
            this.matchedURIs = matchedURIs;
        }

        public void setMatchedResources(LinkedList<ResourceInstance> matchedResources) {
            this.matchedResources = matchedResources;
        }

        public MultivaluedMap<String, String> getMatchedVariables() {
            if (this.matchedVariables == null) {
                this.matchedVariables = new MultivaluedMapImpl();
            }
            return this.matchedVariables;
        }

        public MultivaluedMap<String, List<PathSegment>> getMatchedVariablesPathSegments() {
            if (this.matchedVariablesPathSegments == null) {
                this.matchedVariablesPathSegments = new MultivaluedMapImpl();
            }
            return this.matchedVariablesPathSegments;
        }

        public LinkedList<ResourceInstance> getMatchedResources() {
            if (this.matchedResources == null) {
                this.matchedResources = new LinkedList();
            }
            return this.matchedResources;
        }

        public LinkedList<List<PathSegment>> getMatchedURIs() {
            if (this.matchedURIs == null) {
                this.matchedURIs = new LinkedList();
            }
            return this.matchedURIs;
        }

        public int addMatchedURI(String uri) {
            List segments = this.uriInfo.getPathSegments(false);
            int count = uri.equals("") ? 0 : UriHelper.parsePath((String)uri).size();
            int offset = this.calculateUriOffset();
            this.addMatchedURI(segments, offset, count);
            return count;
        }

        public int calculateUriOffset() {
            int offset = 0;
            if (this.getMatchedURIs().size() > 0) {
                List<PathSegment> firstMatchedUri = this.getMatchedURIs().getFirst();
                offset = firstMatchedUri.size();
                for (PathSegment segment : firstMatchedUri) {
                    if (!segment.getPath().equals("")) continue;
                    --offset;
                }
            }
            return offset;
        }

        private void addMatchedURI(List<PathSegment> segments, int offset, int count) {
            LinkedList<List<PathSegment>> matchedURIs;
            int toIndex = offset + count;
            List subListSegments = segments.subList(offset, toIndex);
            if (subListSegments.isEmpty()) {
                subListSegments = UriHelper.parsePath((String)"");
            }
            if ((matchedURIs = this.getMatchedURIs()).size() == 0) {
                matchedURIs.add(subListSegments);
                return;
            }
            List<PathSegment> currentMatchedUri = matchedURIs.getFirst();
            ArrayList<PathSegment> newMatchedUri = new ArrayList<PathSegment>(currentMatchedUri.size() + subListSegments.size());
            newMatchedUri.addAll(currentMatchedUri);
            newMatchedUri.addAll(subListSegments);
            matchedURIs.addFirst(newMatchedUri);
        }

        public ResourceInstance getResource() {
            return this.matchedResources.getFirst();
        }
    }
}

