/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulateErrorResponseHandler
extends AbstractHandler {
    private static final RuntimeDelegate RUNTIME_DELEGATE = RuntimeDelegate.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(PopulateErrorResponseHandler.class);

    @Override
    public void handleResponse(MessageContext context) throws Throwable {
        Object result = context.getResponseEntity();
        if (result instanceof WebApplicationException) {
            this.handleWebApplicationException(context, (WebApplicationException)result);
        } else if (result instanceof Throwable) {
            Throwable exception = (Throwable)result;
            ExceptionMapper<? extends Throwable> provider = this.findProvider(context, exception);
            if (provider != null) {
                logger.trace("Using provider {} to map exception {}", provider, (Object)exception);
                context.setResponseEntity(this.executeProvider(exception, provider));
            } else {
                throw exception;
            }
        }
    }

    private Response executeProvider(Throwable exception, ExceptionMapper<Throwable> provider) {
        try {
            return provider.toResponse(exception);
        }
        catch (Throwable e) {
            logger.error(Messages.getMessage((String)"exceptionOccurredDuringExceptionMapper", (Object[])new Object[]{provider.getClass().getName()}), e);
            return RUNTIME_DELEGATE.createResponseBuilder().status(500).build();
        }
    }

    private ExceptionMapper<? extends Throwable> findProvider(MessageContext msgContext, Throwable result) {
        return msgContext.getProviders().getExceptionMapper(result.getClass());
    }

    private void handleWebApplicationException(MessageContext msgContext, WebApplicationException exception) {
        ExceptionMapper<? extends Throwable> provider = null;
        if (exception.getResponse().getEntity() == null) {
            provider = this.findProvider(msgContext, (Throwable)exception);
        }
        if (provider != null) {
            logger.trace("Using ExceptionMapper to map response from WebApplicationException");
            msgContext.setResponseEntity(provider.toResponse((Throwable)exception));
        } else {
            logger.trace("Getting response directly from WebApplicationException");
            msgContext.setResponseEntity(exception.getResponse());
        }
    }
}

