/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindRootResourceHandler
implements RequestHandler {
    public static final String SEARCH_POLICY_CONTINUED_SEARCH_KEY = "wink.searchPolicyContinuedSearch";
    private static final Logger logger = LoggerFactory.getLogger(FindRootResourceHandler.class);
    private boolean isContinuedSearchPolicy;

    @Override
    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        ResourceRegistry registry = (ResourceRegistry)context.getAttribute(ResourceRegistry.class);
        List segments = context.getUriInfo().getPathSegments(false);
        logger.trace("Getting URI Info path segments: {}", (Object)segments);
        String strippedPath = this.buildPathForMatching(segments);
        logger.trace("Getting stripped path from segments: {}", (Object)strippedPath);
        List<ResourceInstance> matchedResources = registry.getMatchingRootResources(strippedPath, this.isContinuedSearchPolicy);
        logger.trace("Found resource instances: {}", matchedResources);
        if (matchedResources.size() == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("No resource found matching {}", (Object)context.getUriInfo().getPath(false));
            }
            SearchResult result = new SearchResult(new WebApplicationException(Response.Status.NOT_FOUND));
            context.setAttribute(SearchResult.class, result);
            return;
        }
        for (ResourceInstance resource : matchedResources) {
            SearchResult result = new SearchResult(resource, context.getUriInfo());
            context.setAttribute(SearchResult.class, result);
            resource.getMatcher().storeVariables(result.getData().getMatchedVariables(), false);
            int headSegmentsCount = result.getData().addMatchedURI(resource.getMatcher().getHead(false));
            resource.getMatcher().storeVariablesPathSegments(segments, 0, headSegmentsCount, result.getData().getMatchedVariablesPathSegments());
            logger.trace("Using SearchResult: {}", (Object)result);
            chain.doChain(context);
            if (result.isFound()) break;
            LinkedList<ResourceInstance> resourceInstances = result.getData().getMatchedResources();
            for (ResourceInstance res : resourceInstances) {
                logger.trace("Releasing resource instance");
                res.releaseInstance(context);
            }
        }
    }

    private String buildPathForMatching(List<PathSegment> segments) {
        StringBuilder strippedPathBuilder = new StringBuilder();
        String delim = "";
        for (PathSegment segment : segments) {
            strippedPathBuilder.append(delim);
            strippedPathBuilder.append(segment.getPath());
            delim = "/";
        }
        String strippedPath = strippedPathBuilder.toString();
        return strippedPath;
    }

    @Override
    public void init(Properties props) {
        this.isContinuedSearchPolicy = Boolean.valueOf(props.getProperty(SEARCH_POLICY_CONTINUED_SEARCH_KEY));
    }
}

