/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.json;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.internal.providers.entity.xml.AbstractJAXBCollectionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JAXBArrayJSONProvider
extends AbstractJAXBCollectionProvider
implements MessageBodyReader<Object[]>,
MessageBodyWriter<Object[]> {
    protected volatile MessageBodyReader<Object> readerProvider = null;
    protected volatile MessageBodyWriter<Object> writerProvider = null;
    private static final Logger logger = LoggerFactory.getLogger(JAXBArrayJSONProvider.class);
    @Context
    Providers injectedProviders;

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Class<?> theType = JAXBArrayJSONProvider.getParameterizedTypeClassForRead(type, genericType, false);
        if (theType != null) {
            return type.isArray() && JAXBArrayJSONProvider.isJAXBObject(theType, genericType) && !JAXBArrayJSONProvider.isJAXBElement(theType, genericType);
        }
        return false;
    }

    public long getSize(Object[] t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public Object[] readFrom(Class<Object[]> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        Class<?> theType = JAXBArrayJSONProvider.getParameterizedTypeClassForRead(type, genericType, false);
        if (this.readerProvider == null) {
            this.readerProvider = this.injectedProviders.getMessageBodyReader(theType, theType, annotations, mediaType);
            if (logger.isTraceEnabled()) {
                logger.trace("readerProvider was {} of type {}", (Object)System.identityHashCode(this.readerProvider), (Object)this.readerProvider.getClass().getName());
            }
        }
        LinkedList<String> queue = new LinkedList<String>();
        ArrayList<Object> collection = new ArrayList<Object>();
        Pattern p = Pattern.compile("\\S");
        Matcher m = null;
        int next = entityStream.read();
        while (next != -1) {
            m = p.matcher("" + (char)next);
            if (m.matches() && (char)next != '[') {
                throw new WebApplicationException(500);
            }
            if (!m.matches()) {
                next = (char)entityStream.read();
                continue;
            }
            next = entityStream.read();
            break;
        }
        String objectString = "";
        while (next != -1) {
            if ((char)next != ',' || (char)next == ',' && !queue.isEmpty()) {
                objectString = objectString + (char)next;
            }
            if ((char)next == '{') {
                queue.offer("" + (char)next);
            } else if ((char)next == '}') {
                queue.poll();
                if (queue.isEmpty()) {
                    collection.add(this.readerProvider.readFrom(theType, theType, annotations, mediaType, httpHeaders, (InputStream)new ByteArrayInputStream(objectString.getBytes())));
                    objectString = "";
                }
            }
            next = entityStream.read();
        }
        return (Object[])JAXBArrayJSONProvider.getArray(theType, collection);
    }

    protected static <T> Object getArray(Class<T> type, List<?> collection) {
        Object[] ret = (Object[])Array.newInstance(type, collection.size());
        int i = 0;
        for (Object o : collection) {
            ret[i++] = o;
        }
        return ret;
    }

    public void writeTo(Object[] t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Class<?> theType = JAXBArrayJSONProvider.getParameterizedTypeClassForWrite(type, genericType, false);
        if (this.writerProvider == null) {
            this.writerProvider = this.injectedProviders.getMessageBodyWriter(theType, theType, annotations, mediaType);
            if (logger.isTraceEnabled()) {
                logger.trace("writerProvider was {} of type {}", (Object)System.identityHashCode(this.writerProvider), (Object)this.writerProvider.getClass().getName());
            }
        }
        entityStream.write("[".getBytes());
        int i = 0;
        for (Object o : t) {
            this.writerProvider.writeTo(o, theType, theType, annotations, mediaType, httpHeaders, entityStream);
            if (++i == t.length) continue;
            entityStream.write(",".getBytes());
        }
        entityStream.write("]".getBytes());
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Class<?> theType = JAXBArrayJSONProvider.getParameterizedTypeClassForWrite(type, genericType, false);
        if (theType != null) {
            return JAXBArrayJSONProvider.isJAXBObject(theType, genericType) && !JAXBArrayJSONProvider.isJAXBElement(theType, genericType);
        }
        return false;
    }
}

