/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.application;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.application.ApplicationFileLoader;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.utils.FileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWinkApplication
extends WinkApplication {
    private static final Logger logger = LoggerFactory.getLogger(SimpleWinkApplication.class);
    private static final String FILE_SEPARATOR = ";";
    private final String applicationConfigFiles;
    private Set<Class<?>> jaxRSClasses;

    public SimpleWinkApplication(String applicationConfigFiles) {
        this.applicationConfigFiles = applicationConfigFiles;
    }

    @Override
    public Set<Class<?>> getClasses() {
        if (this.jaxRSClasses != null) {
            return this.jaxRSClasses;
        }
        this.jaxRSClasses = this.loadImplAppConfigFiles();
        return this.jaxRSClasses;
    }

    private Set<Class<?>> loadImplAppConfigFiles() {
        LinkedHashSet jaxRSClasses = new LinkedHashSet();
        if (this.applicationConfigFiles != null) {
            String[] applicationConfigFilesArray;
            for (String applicationConfigFile : applicationConfigFilesArray = this.applicationConfigFiles.split(FILE_SEPARATOR)) {
                applicationConfigFile = applicationConfigFile.trim();
                try {
                    jaxRSClasses.addAll(this.getApplicationFileLoader(this.getFileStream(applicationConfigFile)).getClasses());
                }
                catch (FileNotFoundException e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn(Messages.getMessage("configNotFound", applicationConfigFile));
                }
            }
        }
        return jaxRSClasses;
    }

    protected ApplicationFileLoader getApplicationFileLoader(InputStream is) throws FileNotFoundException {
        return new ApplicationFileLoader(is);
    }

    protected InputStream getFileStream(String applicationConfigFile) throws FileNotFoundException {
        return FileLoader.loadFileAsStream(applicationConfigFile);
    }
}

