/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.json4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.utils.ProviderUtils;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json", "application/javascript"})
@Produces(value={"application/json", "application/javascript"})
public class JSON4JObjectProvider
implements MessageBodyWriter<JSONObject>,
MessageBodyReader<JSONObject> {
    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class == clazz;
    }

    public JSONObject readFrom(Class<JSONObject> clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        try {
            return new JSONObject((Reader)new InputStreamReader(is, ProviderUtils.getCharset((MediaType)mediaType)));
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    public long getSize(JSONObject obj, Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return JSONObject.class.isAssignableFrom(clazz);
    }

    public void writeTo(JSONObject obj, Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(headers, (MediaType)mediaType);
        OutputStreamWriter writer = new OutputStreamWriter(os, ProviderUtils.getCharset((MediaType)mediaType));
        try {
            Writer json4jWriter = obj.write((Writer)writer);
            json4jWriter.flush();
            writer.flush();
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e, 500);
        }
    }
}

