/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.lang.reflect.Field;
import org.apache.jena.iri.ViolationCodes;
import org.apache.jena.iri.impl.VarPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternCompiler
implements ViolationCodes {
    static VarPattern[] ipLiteral = new VarPattern[]{new VarPattern("\\[@{ipVFuture}\\]"), new VarPattern("\\[@{ipV6Address}\\]"), new VarPattern("\\[[^]*", 25)};
    static VarPattern[] ipVFuture = new VarPattern[]{new VarPattern("v@{lowerHexDig}+\\.[-a-zA-Z0-9._~!$&'()*+,;=:]*")};
    static VarPattern[] ipV6Address = new VarPattern[]{new VarPattern("((@{h16}:){6}@{ls32}|::(@{h16}:){5}@{ls32}|@{h16}?::(@{h16}:){4}@{ls32}|((@{h16}:){0,1}@{h16})?::(@{h16}:){3}@{ls32}|((@{h16}:){0,2}@{h16})?::(@{h16}:){2}@{ls32}|((@{h16}:){0,3}@{h16})?::(@{h16}:){1}@{ls32}|((@{h16}:){0,4}@{h16})?::@{ls32}|((@{h16}:){0,5}@{h16})?::@{h16}|((@{h16}:){0,6}@{h16})?::)")};
    static VarPattern[] h16 = new VarPattern[]{new VarPattern("@{lowerHexDig}{1,4}")};
    static VarPattern[] ls32 = new VarPattern[]{new VarPattern("(@{h16}:@{h16}|@{ipV4Address})")};
    static VarPattern[] ipV4Address = new VarPattern[]{new VarPattern("(@{decOctet}\\.){3}@{decOctet}"), new VarPattern("([0-9]+\\.){3}[0-9]+", 27)};
    static VarPattern[] decOctet = new VarPattern[]{new VarPattern("([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])")};
    static VarPattern[] regname = new VarPattern[]{new VarPattern("(@{label}\\.)*@{label}\\.?"), new VarPattern("[^]*", 28)};
    static VarPattern[] host = new VarPattern[]{new VarPattern("@{ipLiteral}"), new VarPattern("@{ipV4Address}"), new VarPattern("@{regname}")};
    static VarPattern[] lowerHexDig = new VarPattern[]{new VarPattern("[0-9a-f]"), new VarPattern("[0-9A-Fa-f]", 26)};
    static VarPattern[] label = new VarPattern[]{new VarPattern("@{labelPrefix}(@{labelInside}@{labelPostfix})?")};
    static VarPattern[] labelInside = new VarPattern[]{new VarPattern("@{labelSingleDashInside}?"), new VarPattern("(@{labelChar}|-)*", 20)};
    static VarPattern[] labelPrefix = new VarPattern[]{new VarPattern("@{labelChar}"), new VarPattern("-|@{labelChar}", 33), new VarPattern("@{labelChar}|@{acePrefix}", 31), new VarPattern("@{labelChar}|@{acePrefix}|-", new int[]{31, 33})};
    static VarPattern[] labelPostfix = new VarPattern[]{new VarPattern("@{labelChar}"), new VarPattern("-|@{labelChar}", 33)};
    static VarPattern[] labelSingleDashInside = new VarPattern[]{new VarPattern("(@{labelChar}+-)*@{labelChar}+")};
    static VarPattern[] acePrefix = new VarPattern[]{new VarPattern("@{letterDigit}{2}--")};
    static VarPattern[] letterDigit = new VarPattern[]{new VarPattern("[a-z0-9]"), new VarPattern("[a-zA-Z0-9]", 11)};
    static VarPattern[] labelChar = new VarPattern[]{new VarPattern("@{unreservedDNSLabel}")};
    static VarPattern[] unreservedDNSLabel = new VarPattern[]{new VarPattern("@{letterDigit}|_"), new VarPattern("@{letterDigit}|[_\\x80-\\uFFFF]", 22)};
    static String[] eCodeNames;

    public static VarPattern[] lookup(String name) {
        try {
            Field f = PatternCompiler.class.getDeclaredField(name);
            return (VarPattern[])f.get(null);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String errorCodeName(int j) {
        if (eCodeNames == null) {
            eCodeNames = PatternCompiler.constantsFromClass(ViolationCodes.class, 200);
        }
        return eCodeNames[j];
    }

    static String[] constantsFromClass(Class<?> cl, int cnt) {
        String[] names = new String[cnt];
        Field[] f = cl.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            try {
                names[f[i].getInt(null)] = f[i].getName();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return names;
    }

    public static int errorCode(String s) throws NoSuchFieldException {
        try {
            Field f = ViolationCodes.class.getDeclaredField(s);
            return f.getInt(null);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

