/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import org.apache.jena.iri.IRIComponents;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.impl.AbsIRIImpl;
import org.apache.jena.iri.impl.IRIFactoryImpl;
import org.apache.jena.iri.impl.Parser;
import org.apache.jena.iri.impl.SchemeSpecificPart;

public class IRIImpl
extends AbsIRIImpl
implements IRIComponents {
    final IRIFactoryImpl factory;
    final String original;
    final Parser parser;
    Exception idnaException;
    SchemeSpecificPart scheme;

    public IRIImpl(IRIFactory f) {
        this(f, "");
    }

    IRIImpl(IRIFactoryImpl f, String s) {
        this.factory = f;
        this.original = s;
        this.parser = new Parser(s, this);
        this.path = this.parser.get(11);
    }

    protected IRIFactoryImpl getFactory() {
        return this.factory;
    }

    long errors(int i) {
        return this.parser.errors(i);
    }

    boolean has(int component) {
        return this.parser.has(component);
    }

    String get(int comp) {
        return this.parser.get(comp);
    }

    String pathRemoveDots() {
        if (this.dotsOK()) {
            return this.path;
        }
        return IRIImpl.removeDotSegments(this.path);
    }

    boolean dotsOK() {
        return (this.errors(11) & 0x100L) == 0L;
    }

    public String toString() {
        return this.original;
    }

    SchemeSpecificPart getSchemeSpec() {
        return this.scheme;
    }

    Exception getIDNAException() {
        return this.idnaException;
    }
}

