/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.net.URI;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Query Capability Resource Shape", describes={"http://open-services.net/ns/core#QueryCapability"})
public final class QueryCapability
extends AbstractResource {
    private final SortedSet<URI> resourceTypes = new TreeSet<URI>();
    private final SortedSet<URI> usages = new TreeSet<URI>();
    private String label;
    private URI queryBase;
    private URI resourceShape;
    private String title;

    public QueryCapability() {
    }

    public QueryCapability(String title, URI queryBase) {
        this();
        this.title = title;
        this.queryBase = queryBase;
    }

    public void addResourceType(URI resourceType) {
        this.resourceTypes.add(resourceType);
    }

    public void addUsage(URI usage) {
        this.usages.add(usage);
    }

    @OslcDescription(value="Very short label for use in menu items")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#label")
    @OslcReadOnly
    @OslcTitle(value="Label")
    public String getLabel() {
        return this.label;
    }

    @OslcDescription(value="The base URI to use for queries. Queries are invoked via HTTP GET on a query URI formed by appending a key=value pair to the base URI, as described in Query Capabilities section")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#queryBase")
    @OslcReadOnly
    @OslcTitle(value="Query Base")
    public URI getQueryBase() {
        return this.queryBase;
    }

    @OslcDescription(value="The Query Capability SHOULD provide a Resource Shape that describes the query base URI")
    @OslcName(value="resourceShape")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#resourceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcReadOnly
    @OslcTitle(value="Resource Shape")
    @OslcValueShape(value="resourceShapes/resourceShape")
    public URI getResourceShape() {
        return this.resourceShape;
    }

    @OslcDescription(value="The expected resource type URI that will be returned with this query capability. These would be the URIs found in the result resource's rdf:type property")
    @OslcName(value="resourceType")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#resourceType")
    @OslcReadOnly
    @OslcTitle(value="Resource Types")
    public URI[] getResourceTypes() {
        return this.resourceTypes.toArray(new URI[this.resourceTypes.size()]);
    }

    @OslcDescription(value="Title string that could be used for display")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcReadOnly
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="An identifier URI for the domain specified usage of this query capability. If a service provides multiple query capabilities, it may designate the primary or default one that should be used with a property value of http://open-services/ns/core#default")
    @OslcName(value="usage")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#usage")
    @OslcReadOnly
    @OslcTitle(value="Usages")
    public URI[] getUsages() {
        return this.usages.toArray(new URI[this.usages.size()]);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setQueryBase(URI queryBase) {
        this.queryBase = queryBase;
    }

    public void setResourceShape(URI resourceShape) {
        this.resourceShape = resourceShape;
    }

    public void setResourceTypes(URI[] resourceTypes) {
        this.resourceTypes.clear();
        if (resourceTypes != null) {
            this.resourceTypes.addAll(Arrays.asList(resourceTypes));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUsages(URI[] usages) {
        this.usages.clear();
        if (usages != null) {
            this.usages.addAll(Arrays.asList(usages));
        }
    }
}

