/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;

public class OSLC4JUtils {
    private static String publicURI = System.getProperty("org.eclipse.lyo.oslc4j.publicURI");
    private static final Logger logger = Logger.getLogger(OSLC4JUtils.class.getName());

    public static String getPublicURI() {
        return publicURI;
    }

    public static void setPublicURI(String newPublicURI) throws MalformedURLException {
        if (newPublicURI != null && !newPublicURI.isEmpty()) {
            URL uRL = new URL(newPublicURI);
        }
        publicURI = newPublicURI;
    }

    public static boolean isHostResolutionDisabled() {
        boolean retVal = false;
        String hostResDisabledProp = System.getProperty("org.eclipse.lyo.oslc4j.disableHostResolution");
        if (hostResDisabledProp != null) {
            retVal = Boolean.parseBoolean(hostResDisabledProp);
        }
        return retVal;
    }

    public static void setHostResolutionDisabled(boolean hostResDisabled) {
        System.setProperty("org.eclipse.lyo.oslc4j.disableHostResolution", Boolean.toString(hostResDisabled));
    }

    public static String resolveURI(HttpServletRequest request, boolean includePath) {
        UriBuilder builder = null;
        String pathInfo = request.getPathInfo();
        String configuredPublicURI = OSLC4JUtils.getPublicURI();
        if (configuredPublicURI != null && !configuredPublicURI.isEmpty()) {
            String uriToBuild = includePath ? configuredPublicURI + "/" + pathInfo : configuredPublicURI;
            builder = UriBuilder.fromUri((String)uriToBuild);
        } else {
            String hostName = "localhost";
            boolean getHostNameFromRequest = false;
            if (OSLC4JUtils.isHostResolutionDisabled()) {
                getHostNameFromRequest = true;
            } else {
                try {
                    hostName = InetAddress.getLocalHost().getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    logger.finer("Unable to resolve hostname.  Extracting hostname from request.");
                    getHostNameFromRequest = true;
                }
            }
            if (getHostNameFromRequest) {
                hostName = request.getServerName();
            }
            String contextPath = request.getContextPath();
            String pathToBuild = includePath ? contextPath + pathInfo : contextPath;
            builder = UriBuilder.fromPath((String)pathToBuild).scheme(request.getScheme()).host(hostName).port(request.getServerPort());
        }
        URI resolvedURI = builder.build(new Object[0]).normalize();
        return resolvedURI.toString();
    }
}

