/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthState;
import org.apache.http.client.AuthCache;
import org.apache.http.protocol.HttpContext;

@Immutable
public class ResponseAuthCache
implements HttpResponseInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        if (authCache != null) {
            this.cache(authCache, (HttpHost)context.getAttribute("http.target_host"), (AuthState)context.getAttribute("http.auth.target-scope"));
            this.cache(authCache, (HttpHost)context.getAttribute("http.proxy_host"), (AuthState)context.getAttribute("http.auth.proxy-scope"));
        }
    }

    private void cache(AuthCache authCache, HttpHost host, AuthState authState) {
        if (authState == null) {
            return;
        }
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null || !authScheme.isComplete()) {
            return;
        }
        String schemeName = authScheme.getSchemeName();
        if (!schemeName.equalsIgnoreCase("Basic") && !schemeName.equalsIgnoreCase("Digest")) {
            return;
        }
        if (authState.getAuthScope() != null) {
            if (authState.getCredentials() != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Caching '" + schemeName + "' auth scheme for " + host));
                }
                authCache.put(host, authScheme);
            } else {
                authCache.remove(host);
            }
        }
    }
}

