/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor;

import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.AbstractRefactoringWithVariableContextAction;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.acceleo.parser.cst.ModuleElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ExtractAsQueryAction
extends AbstractRefactoringWithVariableContextAction {
    public static final String ACTION_ID = "org.eclipse.acceleo.ide.ui.editors.template.actions.refactor.extractAsQuery";
    public static final String COMMAND_ID = "org.eclipse.acceleo.ide.ui.extractAsQuery";

    @Override
    protected int modify(IDocument document, AcceleoSourceContent content, int offset, int length) throws BadLocationException {
        CSTNode parentNode;
        int newOffset = document.getLength();
        CSTNode currentNode = content.getCSTNode(offset, offset + length);
        String paramType = this.getCurrentVariableTypeName(currentNode, "Type");
        String paramName = this.getCurrentVariableName(currentNode, "arg");
        if (currentNode instanceof ModuleElement) {
            newOffset = ((ModuleElement)currentNode).getEndPosition();
        } else if (currentNode != null && (parentNode = content.getCSTParent(currentNode, ModuleElement.class)) instanceof ModuleElement) {
            newOffset = ((ModuleElement)parentNode).getEndPosition();
        }
        String queryName = "new" + paramType + "Query";
        StringBuilder newText = new StringBuilder();
        if (newOffset > 0) {
            newText.append('\n');
            if (!"\n".equals(document.get(newOffset - 1, 1))) {
                newText.append("\n");
            }
        }
        int selectAndReveal = newOffset + newText.length();
        String queryContent = document.get(offset, length);
        newText.append(this.getNewTemplateText(queryName, paramType, paramName, queryContent));
        document.replace(newOffset, 0, newText.toString());
        String templateCall = "[new" + paramType + "Query()/]";
        document.replace(offset, length, templateCall);
        return selectAndReveal += templateCall.length() - length;
    }

    private String getNewTemplateText(String queryName, String paramType, String paramName, String queryContent) {
        StringBuilder newText = new StringBuilder();
        newText.append("[query public " + queryName + " (");
        newText.append(paramName);
        newText.append(" : ");
        newText.append(paramType);
        newText.append(") : OclAny = ");
        newText.append(queryContent);
        newText.append("/]");
        return newText.toString();
    }
}

