/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.forms.widgets.ILayoutExtension;
import org.eclipse.ui.forms.widgets.LayoutCache;
import org.eclipse.ui.forms.widgets.SizeCache;
import org.eclipse.ui.internal.forms.widgets.ColumnLayoutUtils;
import org.eclipse.ui.internal.forms.widgets.FormUtil;

public final class ColumnLayout
extends Layout
implements ILayoutExtension {
    public int minNumColumns = 1;
    public int maxNumColumns = 3;
    public int horizontalSpacing = 5;
    public int verticalSpacing = 5;
    public int topMargin = 5;
    public int leftMargin = 5;
    public int bottomMargin = 5;
    public int rightMargin = 5;
    private LayoutCache cache = new LayoutCache();
    private static final int MIN_SIZE = -2;

    private void updateCache(Composite composite, boolean flushCache) {
        Control[] children = composite.getChildren();
        if (flushCache) {
            this.cache.flush();
        }
        this.cache.setControls(children);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        this.updateCache(composite, flushCache);
        return this.computeSize(composite, wHint, hHint);
    }

    private int clampNumColumns(Composite parent, int desiredNumColumns) {
        int ncolumns = desiredNumColumns;
        ncolumns = Math.min(ncolumns, parent.getChildren().length);
        ncolumns = Math.min(ncolumns, this.maxNumColumns);
        ncolumns = Math.max(ncolumns, this.minNumColumns);
        return Math.max(ncolumns, 1);
    }

    private int computeOptimalNumColumnsForWidth(Composite parent, int width) {
        if (this.minNumColumns >= this.maxNumColumns || parent.getChildren().length <= this.minNumColumns) {
            return this.clampNumColumns(parent, this.minNumColumns);
        }
        Control[] children = parent.getChildren();
        int minColWidth = 0;
        int i = 0;
        while (i < children.length) {
            int nextWidth = this.computeMinimumWidth(i);
            minColWidth = Math.max(minColWidth, nextWidth);
            ++i;
        }
        return this.clampNumColumns(parent, (width - this.leftMargin - this.rightMargin + this.horizontalSpacing) / (minColWidth + this.horizontalSpacing));
    }

    private int computeColumnWidthForNumColumns(int layoutWidth, int numColumns) {
        return (layoutWidth - this.leftMargin - this.rightMargin - (numColumns - 1) * this.horizontalSpacing) / numColumns;
    }

    private Point computeSize(Composite parent, int wHint, int hHint) {
        int i;
        int nColumns;
        Control[] children = parent.getChildren();
        int cheight = 0;
        Point[] sizes = new Point[children.length];
        int columnWidth = 0;
        if (wHint == -1) {
            nColumns = this.clampNumColumns(parent, this.maxNumColumns);
            i = 0;
            while (i < children.length) {
                columnWidth = Math.max(columnWidth, this.computeControlSize((int)i, (int)-1).x);
                ++i;
            }
        } else if (wHint == -2) {
            nColumns = this.clampNumColumns(parent, 0);
            i = 0;
            while (i < children.length) {
                columnWidth = Math.max(columnWidth, this.computeMinimumWidth(i));
                ++i;
            }
        } else {
            nColumns = this.computeOptimalNumColumnsForWidth(parent, wHint);
            columnWidth = this.computeColumnWidthForNumColumns(wHint, nColumns);
        }
        i = 0;
        while (i < children.length) {
            sizes[i] = this.computeControlSize(i, columnWidth);
            cheight += sizes[i].y;
            ++i;
        }
        int perColHeight = ColumnLayoutUtils.computeColumnHeight(nColumns, sizes, cheight, this.verticalSpacing);
        int colHeight = 0;
        int[] heights = new int[nColumns];
        int ncol = 0;
        boolean fillIn = false;
        int i2 = 0;
        while (i2 < sizes.length) {
            int childHeight = sizes[i2].y;
            if (i2 > 0 && colHeight + childHeight > perColHeight) {
                heights[ncol] = colHeight;
                if (++ncol == nColumns || fillIn) {
                    fillIn = true;
                    ncol = this.findShortestColumn(heights);
                }
                colHeight = heights[ncol];
            }
            if (colHeight > 0) {
                colHeight += this.verticalSpacing;
            }
            colHeight += childHeight;
            ++i2;
        }
        heights[ncol] = Math.max(heights[ncol], colHeight);
        Point size = new Point(0, 0);
        int i3 = 0;
        while (i3 < nColumns) {
            size.y = Math.max(size.y, heights[i3]);
            ++i3;
        }
        size.x = columnWidth * nColumns + (nColumns - 1) * this.horizontalSpacing;
        size.x += this.leftMargin + this.rightMargin;
        size.y += this.topMargin + this.bottomMargin;
        if (hHint != -1) {
            size.y = hHint;
        }
        return size;
    }

    private int computeMinimumWidth(int i) {
        SizeCache sc = this.cache.getCache(i);
        return sc.computeMinimumWidth();
    }

    private Point computeControlSize(int controlIndex, int wHint) {
        SizeCache sizeCache = this.cache.getCache(controlIndex);
        Control c = sizeCache.getControl();
        ColumnLayoutData cd = (ColumnLayoutData)c.getLayoutData();
        if (cd != null) {
            return FormUtil.computeControlSize(sizeCache, wHint, cd.widthHint, cd.heightHint, cd.horizontalAlignment == 4);
        }
        return FormUtil.computeControlSize(sizeCache, wHint, -1, -1, true);
    }

    private int findShortestColumn(int[] heights) {
        int result = 0;
        int height = Integer.MAX_VALUE;
        int i = 0;
        while (i < heights.length) {
            if (height > heights[i]) {
                height = heights[i];
                result = i;
            }
            ++i;
        }
        return result;
    }

    protected void layout(Composite parent, boolean flushCache) {
        this.updateCache(parent, flushCache);
        Control[] children = parent.getChildren();
        Rectangle carea = parent.getClientArea();
        int nColumns = this.computeOptimalNumColumnsForWidth(parent, carea.width);
        int columnWidth = this.computeColumnWidthForNumColumns(carea.width, nColumns);
        int cheight = 0;
        Point[] sizes = new Point[children.length];
        int i = 0;
        while (i < children.length) {
            sizes[i] = this.computeControlSize(i, columnWidth);
            cheight += sizes[i].y;
            ++i;
        }
        int perColHeight = ColumnLayoutUtils.computeColumnHeight(nColumns, sizes, cheight, this.verticalSpacing);
        int colHeight = 0;
        int[] heights = new int[nColumns];
        int ncol = 0;
        int x = this.leftMargin;
        boolean fillIn = false;
        int i2 = 0;
        while (i2 < sizes.length) {
            Control child = children[i2];
            Point csize = sizes[i2];
            ColumnLayoutData cd = (ColumnLayoutData)child.getLayoutData();
            int align = cd != null ? cd.horizontalAlignment : 4;
            int childWidth = csize.x;
            if (i2 > 0 && colHeight + csize.y > perColHeight) {
                heights[ncol] = colHeight;
                if (fillIn || ncol == nColumns - 1) {
                    fillIn = true;
                    ncol = this.findShortestColumn(heights);
                    x = this.leftMargin + ncol * (columnWidth + this.horizontalSpacing);
                } else {
                    ++ncol;
                    x += columnWidth + this.horizontalSpacing;
                }
                colHeight = heights[ncol];
            }
            if (colHeight > 0) {
                colHeight += this.verticalSpacing;
            }
            switch (align) {
                case 1: 
                case 4: {
                    child.setBounds(x, this.topMargin + colHeight, childWidth, csize.y);
                    break;
                }
                case 3: {
                    child.setBounds(x + columnWidth - childWidth, this.topMargin + colHeight, childWidth, csize.y);
                    break;
                }
                case 2: {
                    child.setBounds(x + columnWidth / 2 - childWidth / 2, this.topMargin + colHeight, childWidth, csize.y);
                }
            }
            colHeight += csize.y;
            ++i2;
        }
    }

    @Override
    public int computeMaximumWidth(Composite parent, boolean changed) {
        return this.computeSize((Composite)parent, (int)-1, (int)-1, (boolean)changed).x;
    }

    @Override
    public int computeMinimumWidth(Composite parent, boolean changed) {
        this.updateCache(parent, changed);
        return this.computeSize((Composite)parent, (int)-2, (int)-1).x;
    }
}

