/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.providers;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;

public final class FilteredTreeContentProvider
extends AdapterFactoryContentProvider {
    private final Predicate<Object> predicate;

    public FilteredTreeContentProvider(AdapterFactory adapterFactory, Predicate<Object> predicate) {
        super(adapterFactory);
        this.predicate = predicate;
    }

    public Object[] getChildren(Object object) {
        Object[] unfiltered = super.getChildren(object);
        return this.filter(unfiltered);
    }

    public Object[] getElements(Object object) {
        Object[] unfiltered = super.getElements(object);
        return this.filter(unfiltered);
    }

    private Object[] filter(Object[] unfiltered) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        Object[] objectArray = unfiltered;
        int n = unfiltered.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (this.predicate.apply(o)) {
                filtered.add(o);
            }
            ++n2;
        }
        return filtered.toArray(new Object[filtered.size()]);
    }

    public boolean hasChildren(Object object) {
        Object[] children = this.getChildren(object);
        return children != null && children.length != 0;
    }
}

