/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.action;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.action.AbstractExternalJavaAction;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;

public class PrintInterpreterVariablesAction
extends AbstractExternalJavaAction {
    private static final String TITLE_PARAM = "title";
    private static final String ENABLED_PARAM = "enabled";
    private static final String DEFAULT_TITLE = "<no title>";

    @Override
    public boolean canExecute(Collection<? extends EObject> selections) {
        return !selections.isEmpty();
    }

    @Override
    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        Boolean enabled = this.getOptionalParameter(parameters, ENABLED_PARAM, Boolean.class);
        if (enabled != null && !enabled.booleanValue()) {
            return;
        }
        String title = this.getOptionalParameter(parameters, TITLE_PARAM, String.class);
        SortedMap<String, Object> allVariables = this.getSortedVariables(selections);
        this.printVariables(title != null ? title : DEFAULT_TITLE, allVariables);
    }

    private SortedMap<String, Object> getSortedVariables(Collection<? extends EObject> selections) {
        EObject context = selections.iterator().next();
        IInterpreter interpreter = InterpreterUtil.getInterpreter(context);
        TreeMap allVariables = Maps.newTreeMap((Comparator)Ordering.natural());
        allVariables.putAll(interpreter.getVariables());
        allVariables.put("self", context);
        return allVariables;
    }

    private void printVariables(String title, SortedMap<String, Object> allVariables) {
        if (allVariables.isEmpty()) {
            System.out.println("[" + title + "] no variables available.");
        } else {
            int maxLength = ((String)Ordering.natural().onResultOf((Function)new Function<String, Integer>(){

                public Integer apply(String from) {
                    return from.length();
                }
            }).max(allVariables.keySet())).length();
            System.out.println("[" + title + "] variables available:");
            int i = 1;
            for (Map.Entry<String, Object> variable : allVariables.entrySet()) {
                System.out.print("  " + i++ + ". " + variable.getKey());
                int j = 0;
                while (j < maxLength - variable.getKey().length()) {
                    System.out.print(" ");
                    ++j;
                }
                System.out.println(": " + variable.getValue());
            }
            System.out.println();
        }
    }
}

