/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.link;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeManager;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class LinkedModeModel {
    private final List<LinkedPositionGroup> fGroups = new ArrayList<LinkedPositionGroup>();
    private final Set<IDocument> fDocuments = new HashSet<IDocument>();
    private final IPositionUpdater fUpdater = new InclusivePositionUpdater(this.getCategory());
    private final DocumentListener fDocumentListener = new DocumentListener();
    private LinkedModeModel fParentEnvironment;
    private LinkedPosition fParentPosition = null;
    private boolean fIsSealed = false;
    private boolean fIsChanging = false;
    private final List<ILinkedModeListener> fListeners = new ArrayList<ILinkedModeListener>();
    private boolean fIsActive = true;
    private List<LinkedPosition> fPositionSequence = new ArrayList<LinkedPosition>();

    public static boolean hasInstalledModel(IDocument document) {
        return LinkedModeManager.hasManager(document);
    }

    public static boolean hasInstalledModel(IDocument[] documents) {
        return LinkedModeManager.hasManager(documents);
    }

    public static void closeAllModels(IDocument document) {
        LinkedModeManager.cancelManager(document);
    }

    public static LinkedModeModel getModel(IDocument document, int offset) {
        if (!LinkedModeModel.hasInstalledModel(document)) {
            return null;
        }
        LinkedModeManager mgr = LinkedModeManager.getLinkedManager(new IDocument[]{document}, false);
        if (mgr != null) {
            return mgr.getTopEnvironment();
        }
        return null;
    }

    private boolean isChanging() {
        return this.fIsChanging || this.fParentEnvironment != null && this.fParentEnvironment.isChanging();
    }

    private void enforceDisjoint(LinkedPositionGroup group) throws BadLocationException {
        for (LinkedPositionGroup g : this.fGroups) {
            g.enforceDisjoint(group);
        }
    }

    public void exit(int flags) {
        if (!this.fIsActive) {
            return;
        }
        this.fIsActive = false;
        for (IDocument doc : this.fDocuments) {
            try {
                doc.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                Assert.isTrue((boolean)false);
            }
            doc.removePositionUpdater(this.fUpdater);
            doc.removeDocumentListener(this.fDocumentListener);
        }
        this.fDocuments.clear();
        this.fGroups.clear();
        ArrayList<ILinkedModeListener> listeners = new ArrayList<ILinkedModeListener>(this.fListeners);
        this.fListeners.clear();
        for (ILinkedModeListener listener : listeners) {
            listener.left(this, flags);
        }
        if (this.fParentEnvironment != null) {
            this.fParentEnvironment.resume(flags);
        }
    }

    public void stopForwarding(int flags) {
        this.fDocumentListener.fExit = true;
    }

    private void manageDocument(IDocument document) {
        if (!this.fDocuments.contains(document)) {
            this.fDocuments.add(document);
            document.addPositionCategory(this.getCategory());
            document.addPositionUpdater(this.fUpdater);
            document.addDocumentListener(this.fDocumentListener);
        }
    }

    private String getCategory() {
        return this.toString();
    }

    public void addGroup(LinkedPositionGroup group) throws BadLocationException {
        if (group == null) {
            throw new IllegalArgumentException("group may not be null");
        }
        if (this.fIsSealed) {
            throw new IllegalStateException("model is already installed");
        }
        if (this.fGroups.contains(group)) {
            return;
        }
        this.enforceDisjoint(group);
        group.seal();
        this.fGroups.add(group);
    }

    public void forceInstall() throws BadLocationException {
        if (!this.install(true)) {
            Assert.isTrue((boolean)false);
        }
    }

    public boolean tryInstall() throws BadLocationException {
        return this.install(false);
    }

    private boolean install(boolean force) throws BadLocationException {
        if (this.fIsSealed) {
            throw new IllegalStateException("model is already installed");
        }
        this.enforceNotEmpty();
        IDocument[] documents = this.getDocuments();
        LinkedModeManager manager = LinkedModeManager.getLinkedManager(documents, force);
        Assert.isTrue((!force || manager != null ? 1 : 0) != 0);
        if (manager == null) {
            return false;
        }
        if (!manager.nestEnvironment(this, force)) {
            if (force) {
                Assert.isTrue((boolean)false);
            } else {
                return false;
            }
        }
        this.fIsSealed = true;
        if (this.fParentEnvironment != null) {
            this.fParentEnvironment.suspend();
        }
        try {
            for (LinkedPositionGroup group : this.fGroups) {
                group.register(this);
            }
            return true;
        }
        catch (BadLocationException e) {
            this.exit(0);
            throw e;
        }
    }

    private void enforceNotEmpty() {
        boolean hasPosition = false;
        for (LinkedPositionGroup linkedPositionGroup : this.fGroups) {
            if (linkedPositionGroup.isEmpty()) continue;
            hasPosition = true;
            break;
        }
        if (!hasPosition) {
            throw new IllegalStateException("must specify at least one linked position");
        }
    }

    private IDocument[] getDocuments() {
        HashSet<IDocument> docs = new HashSet<IDocument>();
        for (LinkedPositionGroup group : this.fGroups) {
            docs.addAll(Arrays.asList(group.getDocuments()));
        }
        return docs.toArray(new IDocument[docs.size()]);
    }

    boolean canNestInto(LinkedModeModel parent) {
        for (LinkedPositionGroup group : this.fGroups) {
            if (this.enforceNestability(group, parent)) continue;
            this.fParentPosition = null;
            return false;
        }
        Assert.isNotNull((Object)this.fParentPosition);
        this.fParentEnvironment = parent;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean enforceNestability(LinkedPositionGroup group, LinkedModeModel model) {
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)group);
        try {
            for (LinkedPositionGroup pg : model.fGroups) {
                LinkedPosition pos = pg.adopt(group);
                if (pos != null && this.fParentPosition != null && this.fParentPosition != pos) {
                    return false;
                }
                if (this.fParentPosition != null || pos == null) continue;
                this.fParentPosition = pos;
            }
            return this.fParentPosition != null;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public boolean isNested() {
        return this.fParentEnvironment != null;
    }

    public List<LinkedPosition> getTabStopSequence() {
        return this.fPositionSequence;
    }

    public void addLinkingListener(ILinkedModeListener listener) {
        Assert.isNotNull((Object)listener);
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeLinkingListener(ILinkedModeListener listener) {
        this.fListeners.remove(listener);
    }

    public LinkedPosition findPosition(LinkedPosition toFind) {
        LinkedPosition position = null;
        for (LinkedPositionGroup group : this.fGroups) {
            position = group.getPosition(toFind);
            if (position != null) break;
        }
        return position;
    }

    void register(LinkedPosition position) throws BadLocationException {
        Assert.isNotNull((Object)position);
        IDocument document = position.getDocument();
        this.manageDocument(document);
        try {
            document.addPosition(this.getCategory(), position);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            Assert.isTrue((boolean)false);
        }
        int seqNr = position.getSequenceNumber();
        if (seqNr != -1) {
            this.fPositionSequence.add(position);
        }
    }

    private void suspend() {
        ArrayList<ILinkedModeListener> l = new ArrayList<ILinkedModeListener>(this.fListeners);
        for (ILinkedModeListener listener : l) {
            listener.suspend(this);
        }
    }

    private void resume(int flags) {
        ArrayList<ILinkedModeListener> l = new ArrayList<ILinkedModeListener>(this.fListeners);
        for (ILinkedModeListener listener : l) {
            listener.resume(this, flags);
        }
    }

    public boolean anyPositionContains(int offset) {
        for (LinkedPositionGroup group : this.fGroups) {
            if (!group.contains(offset)) continue;
            return true;
        }
        return false;
    }

    public LinkedPositionGroup getGroupForPosition(Position position) {
        for (LinkedPositionGroup group : this.fGroups) {
            if (!group.contains(position)) continue;
            return group;
        }
        return null;
    }

    private class DocumentListener
    implements IDocumentListener {
        private boolean fExit = false;

        private DocumentListener() {
        }

        @Override
        public void documentAboutToBeChanged(DocumentEvent event) {
            if (LinkedModeModel.this.fParentEnvironment != null && LinkedModeModel.this.fParentEnvironment.isChanging()) {
                return;
            }
            for (LinkedPositionGroup group : LinkedModeModel.this.fGroups) {
                if (group.isLegalEvent(event)) continue;
                this.fExit = true;
                return;
            }
        }

        @Override
        public void documentChanged(DocumentEvent event) {
            if (this.fExit) {
                LinkedModeModel.this.exit(8);
                return;
            }
            this.fExit = false;
            if (LinkedModeModel.this.fParentEnvironment != null && LinkedModeModel.this.fParentEnvironment.isChanging()) {
                return;
            }
            Map<IDocument, TextEdit> result = null;
            for (LinkedPositionGroup linkedPositionGroup : LinkedModeModel.this.fGroups) {
                Map<IDocument, TextEdit> map = linkedPositionGroup.handleEvent(event);
                if (result != null && map != null) {
                    LinkedModeModel.this.exit(8);
                    return;
                }
                if (map == null) continue;
                result = map;
            }
            if (result != null) {
                for (Map.Entry entry : result.entrySet()) {
                    IDocument doc = (IDocument)entry.getKey();
                    TextEdit edit = (TextEdit)entry.getValue();
                    Replace replace = new Replace(edit);
                    if (doc == event.getDocument()) {
                        if (!(doc instanceof IDocumentExtension)) continue;
                        ((IDocumentExtension)((Object)doc)).registerPostNotificationReplace(this, replace);
                        continue;
                    }
                    replace.perform(doc, this);
                }
            }
        }
    }

    private class Replace
    implements IDocumentExtension.IReplace {
        private TextEdit fEdit;

        public Replace(TextEdit edit) {
            this.fEdit = edit;
        }

        @Override
        public void perform(IDocument document, IDocumentListener owner) throws RuntimeException, MalformedTreeException {
            document.removeDocumentListener(owner);
            LinkedModeModel.this.fIsChanging = true;
            try {
                try {
                    this.fEdit.apply(document, 3);
                }
                catch (BadLocationException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                document.addDocumentListener(owner);
                LinkedModeModel.this.fIsChanging = false;
            }
        }
    }
}

