/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.operation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.locator.EdgeLabelQuery;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.RectilinearEdgeUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.gmf.runtime.editparts.GraphicalHelper;

public class RemoveBendpointsOperation
extends AbstractModelChangeOperation<Void> {
    private static final String CENTERED_RELATIVE_POINT = "(0.5,0.5)";
    private ConnectionNodeEditPart editPart;

    public RemoveBendpointsOperation(ConnectionNodeEditPart editPart) {
        this.editPart = editPart;
    }

    @Override
    public Void execute() {
        Bendpoints bendpoints;
        Object model = this.editPart.getModel();
        if (model instanceof Edge && (bendpoints = ((Edge)model).getBendpoints()) instanceof RelativeBendpoints) {
            this.computeNewBendpoints();
        }
        return null;
    }

    private void computeNewBendpoints() {
        IFigure figure = this.editPart.getFigure();
        Edge edge = (Edge)this.editPart.getModel();
        Bendpoints bendpoints = ((Edge)this.editPart.getModel()).getBendpoints();
        RelativeBendpoints relativeBendpoints = (RelativeBendpoints)bendpoints;
        int originalNbPoint = relativeBendpoints.getPoints().size();
        if (figure instanceof Connection) {
            Point absoluteSrcAnchorCoordinates = null;
            Point absoluteTgtAnchorCoordinates = null;
            Rectangle srcAbsoluteBounds = this.getFigureBounds(this.editPart.getSource());
            Rectangle tgtAbsoluteBounds = this.getFigureBounds(this.editPart.getTarget());
            EdgeQuery edgeQuery = new EdgeQuery(edge);
            Routing routingStyle = edgeQuery.getRoutingStyle();
            if (Routing.MANUAL_LITERAL.equals(routingStyle)) {
                absoluteSrcAnchorCoordinates = ((Connection)figure).getSourceAnchor().getReferencePoint();
                absoluteTgtAnchorCoordinates = ((Connection)figure).getTargetAnchor().getReferencePoint();
                GraphicalHelper.screen2logical((Point)absoluteSrcAnchorCoordinates, (GraphicalEditPart)this.editPart);
                GraphicalHelper.screen2logical((Point)absoluteTgtAnchorCoordinates, (GraphicalEditPart)this.editPart);
            } else if (Routing.RECTILINEAR_LITERAL.equals(routingStyle)) {
                int newX = srcAbsoluteBounds.x + srcAbsoluteBounds.width / 2;
                int newY = srcAbsoluteBounds.y + srcAbsoluteBounds.height / 2;
                absoluteSrcAnchorCoordinates = new Point(newX, newY);
                newX = tgtAbsoluteBounds.x + tgtAbsoluteBounds.width / 2;
                newY = tgtAbsoluteBounds.y + tgtAbsoluteBounds.height / 2;
                absoluteTgtAnchorCoordinates = new Point(newX, newY);
            }
            if (srcAbsoluteBounds != null && tgtAbsoluteBounds != null) {
                Optional<Point> tgtConnectionBendpoint;
                Optional<Point> srcConnectionBendpoint;
                PointList pointList = null;
                if (Routing.RECTILINEAR_LITERAL.equals(routingStyle) && srcAbsoluteBounds != null && srcAbsoluteBounds.equals((Object)tgtAbsoluteBounds)) {
                    pointList = RectilinearEdgeUtil.computeRectilinearBendpointsSameSourceAndTarget(srcAbsoluteBounds, this.editPart);
                    srcConnectionBendpoint = Optional.ofNullable(pointList.getFirstPoint());
                    tgtConnectionBendpoint = Optional.ofNullable(pointList.getLastPoint());
                } else {
                    srcConnectionBendpoint = GraphicalHelper.getIntersection((Point)absoluteSrcAnchorCoordinates, (Point)absoluteTgtAnchorCoordinates, (Rectangle)srcAbsoluteBounds, (boolean)true, (boolean)true);
                    tgtConnectionBendpoint = GraphicalHelper.getIntersection((Point)absoluteSrcAnchorCoordinates, (Point)absoluteTgtAnchorCoordinates, (Rectangle)tgtAbsoluteBounds, (boolean)false, (boolean)true);
                    if (srcConnectionBendpoint.isPresent() && tgtConnectionBendpoint.isPresent()) {
                        Point srcPoint = srcConnectionBendpoint.get();
                        Point tgtPoint = tgtConnectionBendpoint.get();
                        if (Routing.RECTILINEAR_LITERAL.equals(routingStyle)) {
                            RectilinearEdgeUtil.alignBoundPointTowardAnchor(srcAbsoluteBounds, srcPoint, absoluteSrcAnchorCoordinates);
                            RectilinearEdgeUtil.alignBoundPointTowardAnchor(tgtAbsoluteBounds, tgtPoint, absoluteTgtAnchorCoordinates);
                            pointList = RectilinearEdgeUtil.computeRectilinearBendpoints(srcAbsoluteBounds, tgtAbsoluteBounds, srcPoint, tgtPoint);
                        } else {
                            pointList = new PointList();
                            pointList.addPoint(srcPoint);
                            pointList.addPoint(tgtPoint);
                        }
                    }
                }
                if (srcConnectionBendpoint.isPresent() && tgtConnectionBendpoint.isPresent() && originalNbPoint > pointList.size()) {
                    if (Routing.RECTILINEAR_LITERAL.equals(routingStyle)) {
                        IdentityAnchor srcAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                        IdentityAnchor tgtAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                        srcAnchor.setId(CENTERED_RELATIVE_POINT);
                        tgtAnchor.setId(CENTERED_RELATIVE_POINT);
                        edge.setSourceAnchor((Anchor)srcAnchor);
                        edge.setTargetAnchor((Anchor)tgtAnchor);
                    }
                    relativeBendpoints.setPoints(new ArrayList());
                    this.setNewBendpoints(pointList, absoluteSrcAnchorCoordinates, absoluteTgtAnchorCoordinates);
                }
            }
        }
    }

    private void setNewBendpoints(PointList pointList, Point absoluteSrcAnchorCoordinates, Point absoluteTgtAnchorCoordinates) {
        Object model = this.editPart.getModel();
        if (model instanceof Edge) {
            GMFNotationUtilities.setGMFBendpoints((Edge)model, pointList, absoluteSrcAnchorCoordinates, absoluteTgtAnchorCoordinates);
            List children = this.editPart.getChildren();
            for (Object child : children) {
                AbstractDEdgeNameEditPart labelEditPartToUpdate;
                Node labelNodeToUpdate;
                LayoutConstraint layoutConstraint;
                if (!(child instanceof AbstractDEdgeNameEditPart) || !((layoutConstraint = (labelNodeToUpdate = (Node)(labelEditPartToUpdate = (AbstractDEdgeNameEditPart)child).getModel()).getLayoutConstraint()) instanceof Bounds)) continue;
                Bounds bounds = (Bounds)layoutConstraint;
                Point snapBackPosition = EdgeLabelQuery.getSnapBackPosition(labelEditPartToUpdate.getKeyPoint());
                Bounds labelBounds = NotationFactory.eINSTANCE.createBounds();
                labelBounds.setX(snapBackPosition.x);
                labelBounds.setY(snapBackPosition.y);
                labelBounds.setWidth(bounds.getWidth());
                labelBounds.setHeight(bounds.getHeight());
                labelNodeToUpdate.setLayoutConstraint((LayoutConstraint)labelBounds);
            }
        }
    }

    private Rectangle getFigureBounds(EditPart editPart) {
        if (editPart instanceof GraphicalEditPart) {
            return GraphicalHelper.getAbsoluteBoundsWithoutLabelsIn100Percent((GraphicalEditPart)((GraphicalEditPart)editPart));
        }
        return null;
    }
}

