/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.business.api.extension;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.parser.interpreter.ModuleDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.common.acceleo.mtl.business.api.extension.AbstractImportHandler;
import org.eclipse.sirius.common.acceleo.mtl.business.api.extension.DynamicJavaModuleCreator;
import org.osgi.framework.Bundle;

public class JavaImportHandler
extends AbstractImportHandler {
    private String[] lastFoundService;

    private static List<String> getPublicSignaturesFrom(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList signatures = Lists.newArrayListWithCapacity((int)methods.length);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (Modifier.isPublic(method.getModifiers())) {
                StringBuilder signature = new StringBuilder();
                signature.append(JavaImportHandler.getTypeName(method.getReturnType())).append(' ');
                signature.append(method.getName()).append('(');
                Class<?>[] params = method.getParameterTypes();
                int j = 0;
                while (j < params.length) {
                    signature.append(JavaImportHandler.getTypeName(params[j]));
                    if (j < params.length - 1) {
                        signature.append(',');
                    }
                    ++j;
                }
                signature.append(')');
                signatures.add(signature.toString());
            }
            ++i;
        }
        return signatures;
    }

    private static String getTypeName(Class<?> type) {
        String typeName = null;
        if (type.isArray()) {
            Class<?> enclosingContainer = type.getComponentType();
            String arrays = "[]";
            while (enclosingContainer.isArray()) {
                arrays = String.valueOf(arrays) + "[]";
                enclosingContainer = enclosingContainer.getComponentType();
            }
            typeName = String.valueOf(JavaImportHandler.getTypeName(enclosingContainer)) + arrays;
        } else {
            Class<?> enclosingClass = type.getEnclosingClass();
            typeName = enclosingClass != null ? String.valueOf(JavaImportHandler.getTypeName(enclosingClass)) + type.getName().substring(enclosingClass.getName().length()) : type.getCanonicalName();
        }
        return typeName;
    }

    @Override
    public boolean canImport(Set<String> viewpointPlugins, Set<String> viewpointProjects, String dependency) {
        if (this.lastFoundService != null && this.lastFoundService[0].equals(dependency)) {
            return true;
        }
        this.lastFoundService = null;
        boolean canImport = false;
        try {
            Class.forName(dependency);
            canImport = true;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (!canImport) {
            for (String acessiblePlugin : viewpointPlugins) {
                Bundle bundle = Platform.getBundle((String)acessiblePlugin);
                if (bundle == null) continue;
                try {
                    bundle.loadClass(dependency);
                    canImport = true;
                    this.lastFoundService = new String[]{dependency, acessiblePlugin};
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        return canImport;
    }

    @Override
    public ModuleDescriptor createImport(Set<String> viewpointPlugins, Set<String> viewpointProjects, String dependency) {
        Class clazz = null;
        Bundle bundle = null;
        if (this.lastFoundService != null && this.lastFoundService[0].equals(dependency)) {
            bundle = Platform.getBundle((String)this.lastFoundService[1]);
            try {
                clazz = bundle.loadClass(dependency);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            try {
                clazz = Class.forName(dependency);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            return null;
        }
        List<String> publicSignatures = JavaImportHandler.getPublicSignaturesFrom(clazz);
        ModuleDescriptor module = null;
        if (!publicSignatures.isEmpty()) {
            String moduleContent = DynamicJavaModuleCreator.createModule(dependency, publicSignatures);
            String moduleName = JavaImportHandler.extractModuleName(moduleContent);
            URI moduleURI = bundle == null ? URI.createURI((String)("http://acceleo.eclipse.org/" + moduleName + '.' + "emtl")) : URI.createPlatformPluginURI((String)(String.valueOf(bundle.getSymbolicName()) + '/' + moduleName + '.' + "emtl"), (boolean)true);
            module = new ModuleDescriptor(moduleURI, dependency.replace(".", "::"), moduleContent);
        }
        return module;
    }
}

