/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.types.impl;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.ElementType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TemplateParameterType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.TypesFactory;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.types.impl.AnyTypeImpl;
import org.eclipse.ocl.types.impl.BagTypeImpl;
import org.eclipse.ocl.types.impl.CollectionTypeImpl;
import org.eclipse.ocl.types.impl.ElementTypeImpl;
import org.eclipse.ocl.types.impl.InvalidTypeImpl;
import org.eclipse.ocl.types.impl.MessageTypeImpl;
import org.eclipse.ocl.types.impl.OrderedSetTypeImpl;
import org.eclipse.ocl.types.impl.PrimitiveTypeImpl;
import org.eclipse.ocl.types.impl.SequenceTypeImpl;
import org.eclipse.ocl.types.impl.SetTypeImpl;
import org.eclipse.ocl.types.impl.TemplateParameterTypeImpl;
import org.eclipse.ocl.types.impl.TupleTypeImpl;
import org.eclipse.ocl.types.impl.TypeTypeImpl;
import org.eclipse.ocl.types.impl.VoidTypeImpl;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesFactoryImpl
extends EFactoryImpl
implements TypesFactory {
    public static TypesFactory init() {
        try {
            TypesFactory theTypesFactory = (TypesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/ocl/1.1.0/OCL/Types");
            if (theTypesFactory != null) {
                return theTypesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TypesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createAnyType();
            }
            case 1: {
                return this.createBagType();
            }
            case 2: {
                return this.createCollectionType();
            }
            case 3: {
                return this.createElementType();
            }
            case 4: {
                return this.createInvalidType();
            }
            case 5: {
                return this.createMessageType();
            }
            case 6: {
                return this.createOrderedSetType();
            }
            case 7: {
                return this.createPrimitiveType();
            }
            case 8: {
                return this.createSequenceType();
            }
            case 9: {
                return this.createSetType();
            }
            case 10: {
                return this.createTemplateParameterType();
            }
            case 11: {
                return this.createTupleType();
            }
            case 12: {
                return this.createTypeType();
            }
            case 13: {
                return this.createVoidType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    @Override
    public <O> AnyType<O> createAnyType() {
        AnyTypeImpl anyType = new AnyTypeImpl();
        return anyType;
    }

    @Override
    public <C, O> BagType<C, O> createBagType() {
        BagTypeImpl bagType = new BagTypeImpl();
        return bagType;
    }

    @Override
    public <C, O> CollectionType<C, O> createCollectionType() {
        CollectionTypeImpl collectionType = new CollectionTypeImpl();
        return collectionType;
    }

    @Override
    public ElementType createElementType() {
        ElementTypeImpl elementType = new ElementTypeImpl();
        return elementType;
    }

    @Override
    public <O> InvalidType<O> createInvalidType() {
        InvalidTypeImpl invalidType = new InvalidTypeImpl();
        return invalidType;
    }

    @Override
    public <C, O, P> MessageType<C, O, P> createMessageType() {
        MessageTypeImpl messageType = new MessageTypeImpl();
        return messageType;
    }

    @Override
    public <C, O> OrderedSetType<C, O> createOrderedSetType() {
        OrderedSetTypeImpl orderedSetType = new OrderedSetTypeImpl();
        return orderedSetType;
    }

    @Override
    public <O> PrimitiveType<O> createPrimitiveType() {
        PrimitiveTypeImpl primitiveType = new PrimitiveTypeImpl();
        return primitiveType;
    }

    @Override
    public <C, O> SequenceType<C, O> createSequenceType() {
        SequenceTypeImpl sequenceType = new SequenceTypeImpl();
        return sequenceType;
    }

    @Override
    public <C, O> SetType<C, O> createSetType() {
        SetTypeImpl setType = new SetTypeImpl();
        return setType;
    }

    @Override
    public <O, P> TupleType<O, P> createTupleType() {
        TupleTypeImpl tupleType = new TupleTypeImpl();
        return tupleType;
    }

    @Override
    public <C, O> TypeType<C, O> createTypeType() {
        TypeTypeImpl typeType = new TypeTypeImpl();
        return typeType;
    }

    @Override
    public <O> VoidType<O> createVoidType() {
        VoidTypeImpl voidType = new VoidTypeImpl();
        return voidType;
    }

    @Override
    public <O> TemplateParameterType<O> createTemplateParameterType() {
        TemplateParameterTypeImpl templateParameterType = new TemplateParameterTypeImpl();
        return templateParameterType;
    }

    @Override
    public TypesPackage getTypesPackage() {
        return (TypesPackage)this.getEPackage();
    }

    @Deprecated
    public static TypesPackage getPackage() {
        return TypesPackage.eINSTANCE;
    }

    public <C, O> BagType<C, O> createBagType(C elementType) {
        return new BagTypeImpl(elementType);
    }

    public <C, O> CollectionType<C, O> createCollectionType(C elementType) {
        return new CollectionTypeImpl(elementType);
    }

    public <C, O> CollectionType<C, O> createCollectionType(CollectionKind kind, C elementType) {
        switch (kind) {
            case BAG_LITERAL: {
                return this.createBagType(elementType);
            }
            case SET_LITERAL: {
                return this.createSetType(elementType);
            }
            case SEQUENCE_LITERAL: {
                return this.createSequenceType(elementType);
            }
            case ORDERED_SET_LITERAL: {
                return this.createOrderedSetType(elementType);
            }
        }
        return this.createCollectionType(elementType);
    }

    public <C, O, P> MessageType<C, O, P> createOperationMessageType(O operation) {
        MessageType<C, O, P> result = this.createMessageType();
        result.setReferredOperation(operation);
        return result;
    }

    public <C, O> OrderedSetType<C, O> createOrderedSetType(C elementType) {
        return new OrderedSetTypeImpl(elementType);
    }

    public <C, O> SequenceType<C, O> createSequenceType(C elementType) {
        return new SequenceTypeImpl(elementType);
    }

    public <C, O> SetType<C, O> createSetType(C elementType) {
        return new SetTypeImpl(elementType);
    }

    public <C, O, P> MessageType<C, O, P> createSignalMessageType(C signal) {
        MessageType<C, O, P> result = this.createMessageType();
        result.setReferredSignal(signal);
        return result;
    }

    public <C, O, P> TupleType<O, P> createTupleType(List<? extends TypedElement<C>> parts) {
        TupleType<O, P> result = this.createTupleType();
        if (!parts.isEmpty()) {
            Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(parts.get(0));
            UMLReflection uml = env.getUMLReflection();
            EList<P> properties = result.oclProperties();
            for (TypedElement<C> part : parts) {
                properties.add(uml.createProperty(part.getName(), part.getType()));
            }
        }
        return result;
    }

    public <C, O> TypeType<C, O> createTypeType(C type) {
        return new TypeTypeImpl(type);
    }
}

