/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.impl.inject.RefPair;
import org.apache.felix.scr.impl.inject.ScrComponentContext;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractPrototypeRefPair<S, T>
extends RefPair<S, T> {
    public AbstractPrototypeRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public abstract T getServiceObject(ScrComponentContext var1);

    @Override
    public abstract boolean setServiceObject(ScrComponentContext var1, T var2);

    protected abstract T remove(ScrComponentContext var1);

    protected abstract Collection<Map.Entry<ScrComponentContext, T>> clearEntries();

    @Override
    public final T ungetServiceObject(ScrComponentContext key) {
        if (key == null) {
            Collection<Map.Entry<ScrComponentContext, T>> keys = this.clearEntries();
            for (Map.Entry<ScrComponentContext, T> e : keys) {
                this.doUngetService(e.getKey(), e.getValue());
            }
            return null;
        }
        T service = this.remove(key);
        if (service != null) {
            this.doUngetService(key, service);
        }
        return service;
    }

    @Override
    public final void ungetServiceObjects(BundleContext bundleContext) {
        this.ungetServiceObject(null);
    }

    public abstract String toString();

    @Override
    public final boolean getServiceObject(ScrComponentContext key, BundleContext context) {
        Object service = key.getComponentServiceObjectsHelper().getPrototypeRefInstance(this.getRef());
        if (service == null) {
            this.markFailed();
            key.getLogger().log(InternalLogger.Level.WARN, "Could not get service from serviceobjects for ref {0}", null, this.getRef());
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            this.doUngetService(key, service);
        }
        return true;
    }

    private void doUngetService(ScrComponentContext key, T service) {
        try {
            key.getComponentServiceObjectsHelper().getServiceObjects(this.getRef()).ungetService(service);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

