/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.client.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.client.resources.QmResource;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@Deprecated
@OslcResourceShape(title="Quality Management Resource Shape", describes={"http://open-services.net/ns/qm#TestCase"})
@OslcNamespace(value="http://open-services.net/ns/qm#")
public final class TestCase
extends QmResource {
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<Link> relatedChangeRequests = new HashSet<Link>();
    private final Set<String> subjects = new TreeSet<String>();
    private final Set<Link> testsChangeRequests = new HashSet<Link>();
    private final Set<Link> usesTestScripts = new HashSet<Link>();
    private final Set<Link> validatesRequirements = new HashSet<Link>();
    private String description;

    @Override
    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/qm#TestCase");
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRelatedChangeRequest(Link relatedChangeRequest) {
        this.relatedChangeRequests.add(relatedChangeRequest);
    }

    public void addSubject(String subject) {
        this.subjects.add(subject);
    }

    public void addTestsChangeRequest(Link changeRequest) {
        this.testsChangeRequests.add(changeRequest);
    }

    public void addUsesTestScript(Link testscript) {
        this.usesTestScripts.add(testscript);
    }

    public void addValidatesRequirement(Link requirement) {
        this.validatesRequirements.add(requirement);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the test case.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="A related change request.")
    @OslcName(value="relatedChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#relatedChangeRequest")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Related Change Requests")
    public Link[] getRelatedChangeRequests() {
        return this.relatedChangeRequests.toArray(new Link[this.relatedChangeRequests.size()]);
    }

    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcReadOnly(value=false)
    @OslcTitle(value="Subjects")
    public String[] getSubjects() {
        return this.subjects.toArray(new String[this.subjects.size()]);
    }

    @OslcDescription(value="Change Request tested by the Test Case.")
    @OslcName(value="testsChangeRequest")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#testsChangeRequest")
    @OslcRange(value={"http://open-services.net/ns/cm#ChangeRequest"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Tests Change Request")
    public Link[] getTestsChangeRequests() {
        return this.testsChangeRequests.toArray(new Link[this.testsChangeRequests.size()]);
    }

    @OslcDescription(value="Test Script used by the Test Case.")
    @OslcName(value="usesTestScript")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#usesTestScript")
    @OslcRange(value={"http://open-services.net/ns/qm#TestScript"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Uses Test Script")
    public Link[] getUsesTestScripts() {
        return this.usesTestScripts.toArray(new Link[this.usesTestScripts.size()]);
    }

    @OslcDescription(value="Requirement that is validated by the Test Case.")
    @OslcName(value="validatesRequirement")
    @OslcPropertyDefinition(value="http://open-services.net/ns/qm#validatesRequirement")
    @OslcRange(value={"http://open-services.net/ns/rm#Requirement"})
    @OslcReadOnly(value=false)
    @OslcTitle(value="Validates Requirement")
    public Link[] getValidatesRequirements() {
        return this.validatesRequirements.toArray(new Link[this.validatesRequirements.size()]);
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRelatedChangeRequests(Link[] relatedChangeRequests) {
        this.relatedChangeRequests.clear();
        if (relatedChangeRequests != null) {
            this.relatedChangeRequests.addAll(Arrays.asList(relatedChangeRequests));
        }
    }

    public void setSubjects(String[] subjects) {
        this.subjects.clear();
        if (subjects != null) {
            this.subjects.addAll(Arrays.asList(subjects));
        }
    }

    public void setTestsChangeRequests(Link[] testsChangeRequests) {
        this.testsChangeRequests.clear();
        if (testsChangeRequests != null) {
            this.testsChangeRequests.addAll(Arrays.asList(testsChangeRequests));
        }
    }

    public void setUsesTestScripts(Link[] usesTestScripts) {
        this.usesTestScripts.clear();
        if (usesTestScripts != null) {
            this.usesTestScripts.addAll(Arrays.asList(usesTestScripts));
        }
    }

    public void setValidatesRequirements(Link[] validatesRequirements) {
        this.validatesRequirements.clear();
        if (validatesRequirements != null) {
            this.validatesRequirements.addAll(Arrays.asList(validatesRequirements));
        }
    }
}

