/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.client.resources;

import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.lyo.oslc4j.client.OslcClient;
import org.eclipse.lyo.oslc4j.client.resources.OslcQueryParameters;
import org.eclipse.lyo.oslc4j.client.resources.OslcQueryResult;

public class OslcQuery {
    private final OslcClient oslcClient;
    private final String capabilityUrl;
    private String queryUrl;
    private final int pageSize;
    private WebTarget queryResource;
    private final String where;
    private final String select;
    private final String orderBy;
    private final String searchTerms;
    private final String prefix;
    private final String version;
    private final String configurationContext;

    public OslcQuery(OslcClient oslcClient, String capabilityUrl) {
        this(oslcClient, capabilityUrl, 0);
    }

    public OslcQuery(OslcClient oslcClient, String capabilityUrl, OslcQueryParameters oslcQueryParams) {
        this(oslcClient, capabilityUrl, 0, oslcQueryParams);
    }

    public OslcQuery(OslcClient oslcClient, String capabilityUrl, int pageSize) {
        this(oslcClient, capabilityUrl, pageSize, null);
    }

    public OslcQuery(OslcClient oslcClient, String capabilityUrl, int pageSize, OslcQueryParameters oslcQueryParams) {
        this(oslcClient, capabilityUrl, pageSize, oslcQueryParams, "2.0");
    }

    public OslcQuery(OslcClient oslcClient, String capabilityUrl, int pageSize, OslcQueryParameters oslcQueryParams, String version) {
        this.oslcClient = oslcClient;
        this.capabilityUrl = capabilityUrl;
        int n = this.pageSize = pageSize < 1 ? 0 : pageSize;
        if (oslcQueryParams != null) {
            this.where = oslcQueryParams.getWhere();
            this.select = oslcQueryParams.getSelect();
            this.orderBy = oslcQueryParams.getOrderBy();
            this.searchTerms = oslcQueryParams.getSearchTerms();
            this.prefix = oslcQueryParams.getPrefix();
            this.configurationContext = oslcQueryParams.getConfigurationContext();
        } else {
            this.configurationContext = null;
            this.prefix = null;
            this.searchTerms = null;
            this.orderBy = null;
            this.select = null;
            this.where = null;
        }
        this.queryResource = this.createQueryResource(this.getCapabilityUrl());
        this.queryUrl = this.getQueryUrl();
        this.version = version;
    }

    OslcQuery(OslcQueryResult previousResult) {
        this(previousResult.getQuery(), previousResult.getNextPageUrl());
    }

    private OslcQuery(OslcQuery previousQuery, String nextPageUrl) {
        this(previousQuery.oslcClient, previousQuery.capabilityUrl, previousQuery.pageSize);
        this.queryUrl = nextPageUrl;
        this.queryResource = this.createQueryResource(nextPageUrl);
    }

    private WebTarget createQueryResource(String capabilityUri) {
        WebTarget resource = this.oslcClient.getWebResource(capabilityUri);
        resource = this.applyPagination(resource);
        resource = this.applyOslcQueryParams(resource);
        return resource;
    }

    private WebTarget applyPagination(WebTarget resource) {
        WebTarget result = resource;
        if (this.pageSize > 0) {
            result = result.queryParam("oslc.paging", new Object[]{"true"});
            result = result.queryParam("oslc.pageSize", new Object[]{this.pageSize});
        }
        return result;
    }

    private WebTarget applyOslcQueryParams(WebTarget resource) {
        WebTarget result = resource;
        if (this.where != null && !this.where.isEmpty()) {
            result = result.queryParam("oslc.where", new Object[]{this.where});
        }
        if (this.select != null && !this.select.isEmpty()) {
            result = result.queryParam("oslc.select", new Object[]{this.select});
        }
        if (this.orderBy != null && !this.orderBy.isEmpty()) {
            result = result.queryParam("oslc.orderBy", new Object[]{this.orderBy});
        }
        if (this.searchTerms != null && !this.searchTerms.isEmpty()) {
            result = result.queryParam("oslc.searchTerms", new Object[]{this.searchTerms});
        }
        if (this.prefix != null && !this.prefix.isEmpty()) {
            result = result.queryParam("oslc.prefix", new Object[]{this.prefix});
        }
        if (this.configurationContext != null && !this.configurationContext.isEmpty()) {
            result = result.queryParam("oslc_config.context", new Object[]{this.configurationContext});
        }
        return result;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getCapabilityUrl() {
        return this.capabilityUrl;
    }

    public String getQueryUrl() {
        if (this.queryUrl == null) {
            this.queryUrl = this.queryResource.getUriBuilder().build(new Object[0]).toString();
        }
        return this.queryUrl;
    }

    public OslcQueryResult submit() {
        return new OslcQueryResult(this, this.getResponse());
    }

    Response getResponse() {
        return this.queryResource.request(new String[]{"application/rdf+xml"}).header("OSLC-Core-Version", (Object)this.version).get();
    }
}

