/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.client.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.client.resources.ParameterInstance;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Link;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@OslcResourceShape(title="Automation Result Resource Shape", describes={"http://open-services.net/ns/auto#AutomationResult"})
@OslcNamespace(value="http://open-services.net/ns/auto#")
public final class AutomationResult
extends AbstractResource {
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<URI> rdfTypes = new TreeSet<URI>();
    private final Set<String> subjects = new TreeSet<String>();
    private final Set<URI> states = new TreeSet<URI>();
    private final Set<URI> verdicts = new TreeSet<URI>();
    private final Set<URI> contributions = new TreeSet<URI>();
    private final Set<ParameterInstance> inputParameters = new TreeSet<ParameterInstance>();
    private final Set<ParameterInstance> outputParameters = new TreeSet<ParameterInstance>();
    private Date created;
    private String identifier;
    private URI instanceShape;
    private Date modified;
    private URI serviceProvider;
    private String title;
    private URI desiredState;
    private Link producedByAutomationRequest;
    private Link reportsOnAutomationPlan;

    public AutomationResult() {
        this.rdfTypes.add(URI.create("http://open-services.net/ns/auto#AutomationResult"));
    }

    public AutomationResult(URI about) {
        super(about);
        this.rdfTypes.add(URI.create("http://open-services.net/ns/auto#AutomationResult"));
    }

    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/auto#AutomationResult");
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRdfType(URI rdfType) {
        this.rdfTypes.add(rdfType);
    }

    public void addSubject(String subject) {
        this.subjects.add(subject);
    }

    public void addState(URI state) {
        this.states.add(state);
    }

    public void addVerdict(URI verdict) {
        this.verdicts.add(verdict);
    }

    public void addContribution(URI contribution) {
        this.contributions.add(contribution);
    }

    public void addInputParameter(ParameterInstance parameter) {
        this.inputParameters.add(parameter);
    }

    public void addOutputParameter(ParameterInstance parameter) {
        this.outputParameters.add(parameter);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the automation result.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Timestamp of resource creation.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcReadOnly
    @OslcTitle(value="Created")
    public Date getCreated() {
        return this.created;
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="A unique identifier for a resource. Assigned by the service provider when a resource is created. Not intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcTitle(value="Identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcTitle(value="Instance Shape")
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    @OslcDescription(value="Timestamp last latest resource modification.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcReadOnly
    @OslcTitle(value="Modified")
    public Date getModified() {
        return this.modified;
    }

    @OslcDescription(value="The resource type URIs.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Types")
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcTitle(value="Service Provider")
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    @OslcDescription(value="Tag or keyword for a resource. Each occurrence of a dcterms:subject property denotes an additional tag for the resource.")
    @OslcName(value="subject")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/subject")
    @OslcReadOnly(value=false)
    @OslcTitle(value="Subjects")
    public String[] getSubjects() {
        return this.subjects.toArray(new String[this.subjects.size()]);
    }

    @OslcDescription(value="Title (reference: Dublin Core) or often a single line summary of the resource represented as rich text in XHTML content.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    @OslcDescription(value="Used to indicate the state of the automation result based on values defined by the service provider.")
    @OslcOccurs(value=Occurs.OneOrMany)
    @OslcReadOnly(value=true)
    @OslcName(value="state")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#state")
    @OslcTitle(value="State")
    @OslcAllowedValue(value={"http://open-services.net/ns/auto#http://open-services.net/ns/auto#new", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#inProgress", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#queued", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#canceling", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#canceled", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#complete"})
    public URI[] getStates() {
        return this.states.toArray(new URI[this.states.size()]);
    }

    @OslcDescription(value="A result contribution associated with this automation result.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcName(value="contribution")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#contribution")
    @OslcTitle(value="Contribution")
    public URI[] getContributions() {
        return this.contributions.toArray(new URI[this.contributions.size()]);
    }

    @OslcDescription(value="Used to indicate the verdict of the automation result based on values defined by the service provider.")
    @OslcOccurs(value=Occurs.OneOrMany)
    @OslcName(value="verdict")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#verdict")
    @OslcTitle(value="Verdict")
    @OslcAllowedValue(value={"http://open-services.net/ns/auto#http://open-services.net/ns/auto#passed", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#failed", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#warning", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#error", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#unavailable"})
    public URI[] getVerdicts() {
        return this.verdicts.toArray(new URI[this.verdicts.size()]);
    }

    @OslcDescription(value="Used to indicate the desired state of the Automation Request based on values defined by the service provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#desiredState")
    @OslcName(value="desiredState")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcTitle(value="Desired State")
    @OslcAllowedValue(value={"http://open-services.net/ns/auto#http://open-services.net/ns/auto#new", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#inProgress", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#queued", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#canceling", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#canceled", "http://open-services.net/ns/auto#http://open-services.net/ns/auto#complete"})
    public URI getDesiredState() {
        return this.desiredState;
    }

    @OslcDescription(value="Automation Request which produced the Automation Result.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#producedByAutomationRequest")
    @OslcName(value="producedByAutomationRequest")
    @OslcOccurs(value=Occurs.ZeroOrOne)
    @OslcTitle(value="Produced By Automation Request")
    public Link getProducedByAutomationRequest() {
        return this.producedByAutomationRequest;
    }

    @OslcDescription(value="Automation Plan which the Automation Result reports on.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#reportsOnAutomationPlan")
    @OslcName(value="reportsOnAutomationPlan")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcTitle(value="Reports On Automation Plan")
    public Link getReportsOnAutomationPlan() {
        return this.reportsOnAutomationPlan;
    }

    @OslcDescription(value="A copy of the parameters provided during creation of the Automation Request which produced this Automation Result.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcName(value="inputParameter")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#inputParameter")
    @OslcReadOnly(value=true)
    @OslcTitle(value="Input Parameter")
    public ParameterInstance[] getInputParameters() {
        return this.inputParameters.toArray(new ParameterInstance[this.inputParameters.size()]);
    }

    @OslcDescription(value="Automation Result output parameters are parameters associated with the automation execution which produced this Result. This includes the final value of all parameters used to initiate the execution and any additional parameters which may have been created during automation execution by the service provider or external agents.")
    @OslcOccurs(value=Occurs.ZeroOrMany)
    @OslcName(value="outputParameter")
    @OslcPropertyDefinition(value="http://open-services.net/ns/auto#outputParameter")
    @OslcTitle(value="Output Parameter")
    public ParameterInstance[] getOutputParameters() {
        return this.outputParameters.toArray(new ParameterInstance[this.outputParameters.size()]);
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    public void setServiceProvider(URI serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setSubjects(String[] subjects) {
        this.subjects.clear();
        if (subjects != null) {
            this.subjects.addAll(Arrays.asList(subjects));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStates(URI[] states) {
        this.states.clear();
        if (states != null) {
            this.states.addAll(Arrays.asList(states));
        }
    }

    public void setVerdicts(URI[] verdicts) {
        this.verdicts.clear();
        if (verdicts != null) {
            this.verdicts.addAll(Arrays.asList(verdicts));
        }
    }

    public void setContributions(URI[] contributions) {
        this.contributions.clear();
        if (contributions != null) {
            this.contributions.addAll(Arrays.asList(contributions));
        }
    }

    public void setDesiredState(URI desiredState) {
        this.desiredState = desiredState;
    }

    public void setProducedByAutomationRequest(Link producedByAutomationRequest) {
        this.producedByAutomationRequest = producedByAutomationRequest;
    }

    public void setReportsOnAutomationPlan(Link reportsOnAutomationPlan) {
        this.reportsOnAutomationPlan = reportsOnAutomationPlan;
    }

    public void setInputParameters(ParameterInstance[] parameters) {
        this.inputParameters.clear();
        if (parameters != null) {
            this.inputParameters.addAll(Arrays.asList(parameters));
        }
    }

    public void setOutputParameters(ParameterInstance[] parameters) {
        this.outputParameters.clear();
        if (parameters != null) {
            this.outputParameters.addAll(Arrays.asList(parameters));
        }
    }
}

