/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.client.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

@Deprecated
@OslcResourceShape(title="Architecture Management Resource Resource Shape", describes={"http://open-services.net/ns/am#Resource"})
@OslcNamespace(value="http://open-services.net/ns/am#")
@OslcName(value="Resource")
public final class ArchitectureResource
extends AbstractResource {
    private final Set<URI> contributors = new TreeSet<URI>();
    private final Set<URI> creators = new TreeSet<URI>();
    private final Set<String> dctermsTypes = new TreeSet<String>();
    private final Set<URI> rdfTypes = new TreeSet<URI>();
    private Date created;
    private String description;
    private String identifier;
    private URI source;
    private URI instanceShape;
    private Date modified;
    private URI serviceProvider;
    private String title;

    public ArchitectureResource() {
        this.rdfTypes.add(URI.create("http://open-services.net/ns/am#Resource"));
    }

    public ArchitectureResource(URI about) {
        super(about);
        this.rdfTypes.add(URI.create("http://open-services.net/ns/am#Resource"));
    }

    protected URI getRdfType() {
        return URI.create("http://open-services.net/ns/am#Resource");
    }

    public void addContributor(URI contributor) {
        this.contributors.add(contributor);
    }

    public void addCreator(URI creator) {
        this.creators.add(creator);
    }

    public void addRdfType(URI rdfType) {
        this.rdfTypes.add(rdfType);
    }

    public void addDctermsType(String dctermsType) {
        this.dctermsTypes.add(dctermsType);
    }

    @OslcDescription(value="The person(s) who are responsible for the work needed to complete the automation plan.")
    @OslcName(value="contributor")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/contributor")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Contributors")
    public URI[] getContributors() {
        return this.contributors.toArray(new URI[this.contributors.size()]);
    }

    @OslcDescription(value="Timestamp of resource creation.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/created")
    @OslcReadOnly
    @OslcTitle(value="Created")
    public Date getCreated() {
        return this.created;
    }

    @OslcDescription(value="Creator or creators of resource.")
    @OslcName(value="creator")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/creator")
    @OslcRange(value={"http://xmlns.com/foaf/0.1/Person"})
    @OslcTitle(value="Creators")
    public URI[] getCreators() {
        return this.creators.toArray(new URI[this.creators.size()]);
    }

    @OslcDescription(value="Descriptive text (reference: Dublin Core) about resource represented as rich text in XHTML content.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="A unique identifier for a resource. Assigned by the service provider when a resource is created. Not intended for end-user display.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/identifier")
    @OslcReadOnly
    @OslcTitle(value="Identifier")
    public String getIdentifier() {
        return this.identifier;
    }

    @OslcDescription(value="Resource Shape that provides hints as to resource property value-types and allowed values. ")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#instanceShape")
    @OslcRange(value={"http://open-services.net/ns/core#ResourceShape"})
    @OslcTitle(value="Instance Shape")
    public URI getInstanceShape() {
        return this.instanceShape;
    }

    @OslcDescription(value="Timestamp last latest resource modification.")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/modified")
    @OslcReadOnly
    @OslcTitle(value="Modified")
    public Date getModified() {
        return this.modified;
    }

    @OslcDescription(value="The resource type URIs.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://www.w3.org/1999/02/22-rdf-syntax-ns#type")
    @OslcTitle(value="Types")
    public URI[] getRdfTypes() {
        return this.rdfTypes.toArray(new URI[this.rdfTypes.size()]);
    }

    @OslcDescription(value="A short string representation for the type, example 'Defect'.")
    @OslcName(value="type")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/type")
    @OslcTitle(value="DCTerms Types")
    public String[] getDctermsTypes() {
        return this.dctermsTypes.toArray(new String[this.dctermsTypes.size()]);
    }

    @OslcDescription(value="The resource URI a client can perform a get on to obtain the original non-OSLC AM formatted resource that was used to create this resource. ")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/source")
    @OslcTitle(value="Source")
    public URI getSource() {
        return this.source;
    }

    @OslcDescription(value="The scope of a resource is a URI for the resource's OSLC Service Provider.")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcTitle(value="Service Provider")
    public URI getServiceProvider() {
        return this.serviceProvider;
    }

    @OslcDescription(value="Title (reference: Dublin Core) or often a single line summary of the resource represented as rich text in XHTML content.")
    @OslcOccurs(value=Occurs.ExactlyOne)
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    public void setContributors(URI[] contributors) {
        this.contributors.clear();
        if (contributors != null) {
            this.contributors.addAll(Arrays.asList(contributors));
        }
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setCreators(URI[] creators) {
        this.creators.clear();
        if (creators != null) {
            this.creators.addAll(Arrays.asList(creators));
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setInstanceShape(URI instanceShape) {
        this.instanceShape = instanceShape;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setRdfTypes(URI[] rdfTypes) {
        this.rdfTypes.clear();
        if (rdfTypes != null) {
            this.rdfTypes.addAll(Arrays.asList(rdfTypes));
        }
    }

    public void setDctermsTypes(String[] dctermsTypes) {
        this.dctermsTypes.clear();
        if (dctermsTypes != null) {
            this.dctermsTypes.addAll(Arrays.asList(dctermsTypes));
        }
    }

    public void setSource(URI source) {
        this.source = source;
    }

    public void setServiceProvider(URI serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

