/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.sys;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.tdb.StoreConnection;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.sys.TDBInternal;
import org.apache.jena.tdb.transaction.DatasetGraphTransaction;

public class TDBMaker {
    private static final boolean CACHING = true;
    private static final Map<Location, DatasetGraphTransaction> cache = new ConcurrentHashMap<Location, DatasetGraphTransaction>();

    static DatasetGraphTransaction createDatasetGraphTransaction(String location) {
        return TDBMaker.createDatasetGraphTransaction(Location.create(location));
    }

    public static DatasetGraphTransaction createDatasetGraphTransaction(Location location) {
        return TDBMaker._create(location);
    }

    public static DatasetGraphTransaction createDatasetGraphTransaction() {
        return TDBMaker.createDatasetGraphTransaction(Location.mem());
    }

    public static void releaseLocation(Location location) {
        if (!location.isMemUnique()) {
            cache.remove(location);
        }
        StoreConnection.release(location);
    }

    @Deprecated
    public static void reset() {
        TDBInternal.reset();
    }

    public static void resetCache() {
        cache.clear();
    }

    private static DatasetGraphTransaction _create(Location location) {
        if (location.isMemUnique()) {
            return TDBMaker.createDirect(location);
        }
        return cache.computeIfAbsent(location, TDBMaker::createDirect);
    }

    public static DatasetGraphTransaction createDirect(Location location) {
        return new DatasetGraphTransaction(location);
    }
}

