/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.parser;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.engine.TargetOps;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.PropertyShape;
import org.apache.jena.shacl.parser.ShapeVisitor;
import org.apache.jena.shacl.validation.Severity;

public abstract class Shape {
    protected final Graph shapeGraph;
    protected final Node shapeNode;
    protected final boolean deactivated;
    protected final Severity severity;
    protected final Collection<Node> messages;
    protected final Collection<Target> targets;
    protected final List<Constraint> constraints;
    protected final List<PropertyShape> propertyShapes;

    public Shape(Graph shapeGraph, Node shapeNode, boolean deactivated, Severity severity, List<Node> messages, Collection<Target> targets, List<Constraint> constraints, List<PropertyShape> propertyShapes) {
        this.shapeGraph = shapeGraph;
        this.shapeNode = shapeNode;
        this.deactivated = deactivated;
        this.severity = severity;
        this.messages = messages;
        this.targets = targets;
        this.constraints = constraints;
        this.propertyShapes = propertyShapes;
    }

    public abstract void visit(ShapeVisitor var1);

    public Graph getShapeGraph() {
        return this.shapeGraph;
    }

    public Node getShapeNode() {
        return this.shapeNode;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Collection<Node> getMessages() {
        return this.messages;
    }

    public Collection<Target> getTargets() {
        return this.targets;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<PropertyShape> getPropertyShapes() {
        return this.propertyShapes;
    }

    public boolean deactivated() {
        return this.deactivated;
    }

    public abstract String toString();

    public void print(OutputStream out) {
        if (!(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out, 131072);
        }
        IndentedWriter w = new IndentedWriter(out);
        this.print(w);
    }

    protected abstract void printHeader(IndentedWriter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(IndentedWriter out) {
        this.printHeader(out);
        if (this.deactivated()) {
            out.print(" deactivated");
        }
        if (!this.targets.isEmpty()) {
            out.print(" :: ");
            out.print(TargetOps.strTargets(this.targets));
        }
        out.println();
        out.incIndent();
        try {
            for (Constraint c : this.constraints) {
                c.print(out);
                out.println();
            }
            for (PropertyShape ps : this.getPropertyShapes()) {
                ps.print(out);
            }
        }
        finally {
            out.decIndent();
        }
    }
}

