/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.graph.Node;
import org.apache.jena.shacl.engine.Parameter;

public class SparqlComponent {
    private final Node reportNode;
    private final String sparqlString;
    private final boolean isSelect;
    private final List<Parameter> params;
    private final List<Node> requiredParameters;
    private final List<Node> optionalParameters;

    public SparqlComponent(Node reportNode, boolean isSelect, String sparqlString, List<Parameter> params) {
        this.reportNode = reportNode;
        this.sparqlString = sparqlString;
        this.isSelect = isSelect;
        this.params = params;
        this.requiredParameters = params.stream().filter(param -> !param.isOptional()).map(param -> param.getParameterPath()).collect(Collectors.toList());
        this.optionalParameters = params.stream().filter(param -> param.isOptional()).map(param -> param.getParameterPath()).collect(Collectors.toList());
    }

    public Node getReportComponent() {
        return this.reportNode;
    }

    public String getSparqlString() {
        return this.sparqlString;
    }

    public boolean isSelect() {
        return this.isSelect;
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public List<Node> getRequiredParameters() {
        return this.requiredParameters;
    }

    public List<Node> getOptionalParameters() {
        return this.optionalParameters;
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        if (this.isSelect) {
            sbuff.append("SELECT:");
        } else {
            sbuff.append("ASK:");
        }
        sbuff.append(this.params.toString());
        return sbuff.toString();
    }
}

