/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.prefixes.PrefixEntry;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Quad;

public class PrefixLib {
    public static String canonicalPrefix(String prefix) {
        if (prefix.endsWith(":")) {
            return prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    public static Node canonicalGraphName(Node graphName) {
        if (graphName == null || Quad.isDefaultGraph((Node)graphName)) {
            return StoragePrefixes.nodeDefaultGraph;
        }
        return graphName;
    }

    public static String abbreviate(PrefixMapI pmap, String uriStr) {
        for (PrefixEntry e : pmap) {
            String ln;
            String prefix = e.getPrefix();
            String prefixUri = e.getUri();
            if (!uriStr.startsWith(prefixUri) || !PrefixLib.strSafeFor(ln = uriStr.substring(prefixUri.length()), '/') || !PrefixLib.strSafeFor(ln, '#') || !PrefixLib.strSafeFor(ln, ':')) continue;
            return prefix + ":" + ln;
        }
        return null;
    }

    private static boolean strSafeFor(String str, char ch) {
        return str.indexOf(ch) == -1;
    }

    public static Pair<String, String> abbrev(PrefixMapI prefixes, String uriStr) {
        for (PrefixEntry e : prefixes) {
            String uriForPrefix = e.getUri();
            if (!uriStr.startsWith(uriForPrefix)) continue;
            return Pair.create((Object)e.getPrefix(), (Object)uriStr.substring(uriForPrefix.length()));
        }
        return null;
    }

    public static String expand(PrefixMapI prefixes, String prefixedName) {
        int i = prefixedName.indexOf(58);
        if (i < 0) {
            return null;
        }
        return PrefixLib.expand(prefixes, prefixedName.substring(0, i), prefixedName.substring(i + 1));
    }

    public static String expand(PrefixMapI prefixes, String prefix, String localName) {
        String x = prefixes.get(prefix = PrefixLib.canonicalPrefix(prefix));
        if (x == null) {
            return null;
        }
        return x + localName;
    }
}

