/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import io.github.classgraph.ModuleRef;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.classpath.CallStackReader;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.CollectionUtils;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

public class ClassLoaderAndModuleFinder {
    private final ClassLoader[] contextClassLoaders;
    private List<ModuleRef> systemModuleRefs;
    private List<ModuleRef> nonSystemModuleRefs;

    public ClassLoader[] getContextClassLoaders() {
        return this.contextClassLoaders;
    }

    public List<ModuleRef> getSystemModuleRefs() {
        return this.systemModuleRefs;
    }

    public List<ModuleRef> getNonSystemModuleRefs() {
        return this.nonSystemModuleRefs;
    }

    private static void findLayerOrder(Object layer, Set<Object> layerVisited, Set<Object> parentLayers, Deque<Object> layerOrderOut) {
        if (layerVisited.add(layer)) {
            List parents = (List)ReflectionUtils.invokeMethod(layer, "parents", true);
            if (parents != null) {
                parentLayers.addAll(parents);
                for (Object parent : parents) {
                    ClassLoaderAndModuleFinder.findLayerOrder(parent, layerVisited, parentLayers, layerOrderOut);
                }
            }
            layerOrderOut.push(layer);
        }
    }

    private static List<ModuleRef> findModuleRefs(LinkedHashSet<Object> layers, ScanSpec scanSpec, LogNode log) {
        ArrayList<Object> layerOrderFinal;
        if (layers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayDeque<Object> layerOrder = new ArrayDeque<Object>();
        HashSet<Object> parentLayers = new HashSet<Object>();
        for (Object layer : layers) {
            ClassLoaderAndModuleFinder.findLayerOrder(layer, new HashSet<Object>(), parentLayers, layerOrder);
        }
        if (scanSpec.addedModuleLayers != null) {
            for (Object layer : scanSpec.addedModuleLayers) {
                ClassLoaderAndModuleFinder.findLayerOrder(layer, new HashSet<Object>(), parentLayers, layerOrder);
            }
        }
        if (scanSpec.ignoreParentModuleLayers) {
            layerOrderFinal = new ArrayList();
            for (Object e : layerOrder) {
                if (parentLayers.contains(e)) continue;
                layerOrderFinal.add(e);
            }
        } else {
            layerOrderFinal = new ArrayList<Object>(layerOrder);
        }
        HashSet<Object> addedModules = new HashSet<Object>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object e : layerOrderFinal) {
            Set modules;
            Object configuration = ReflectionUtils.invokeMethod(e, "configuration", true);
            if (configuration == null || (modules = (Set)ReflectionUtils.invokeMethod(configuration, "modules", true)) == null) continue;
            ArrayList<ModuleRef> modulesInLayer = new ArrayList<ModuleRef>();
            for (Object module : modules) {
                Object moduleReference = ReflectionUtils.invokeMethod(module, "reference", true);
                if (moduleReference == null || !addedModules.add(moduleReference)) continue;
                try {
                    modulesInLayer.add(new ModuleRef(moduleReference, e));
                }
                catch (IllegalArgumentException e2) {
                    if (log == null) continue;
                    log.log("Exception while creating ModuleRef for module " + moduleReference, e2);
                }
            }
            CollectionUtils.sortIfNotEmpty(modulesInLayer);
            linkedHashSet.addAll(modulesInLayer);
        }
        return new ArrayList<ModuleRef>(linkedHashSet);
    }

    private static List<ModuleRef> findModuleRefsFromCallstack(Class<?>[] callStack, ScanSpec scanSpec, LogNode log) {
        Object bootLayer;
        LinkedHashSet<Object> layers = new LinkedHashSet<Object>();
        if (callStack != null) {
            for (Class<?> stackFrameClass : callStack) {
                Object layer;
                Object module = ReflectionUtils.invokeMethod(stackFrameClass, "getModule", false);
                if (module == null || (layer = ReflectionUtils.invokeMethod(module, "getLayer", true)) == null) continue;
                layers.add(layer);
            }
        }
        Class<?> moduleLayerClass = null;
        try {
            moduleLayerClass = Class.forName("java.lang.ModuleLayer");
        }
        catch (ClassNotFoundException | LinkageError throwable) {
            // empty catch block
        }
        if (moduleLayerClass != null && (bootLayer = ReflectionUtils.invokeStaticMethod(moduleLayerClass, "boot", false)) != null) {
            layers.add(bootLayer);
        }
        return ClassLoaderAndModuleFinder.findModuleRefs(layers, scanSpec, log);
    }

    ClassLoaderAndModuleFinder(ScanSpec scanSpec, LogNode log) {
        LogNode classLoadersFoundLog;
        LinkedHashSet<Object> classLoadersUnique;
        if (scanSpec.overrideClassLoaders == null) {
            Class<?>[] callStack;
            block25: {
                ClassLoader systemClassLoader;
                ClassLoader currClassClassLoader;
                classLoadersUnique = new LinkedHashSet();
                ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
                if (threadClassLoader != null) {
                    classLoadersUnique.add(threadClassLoader);
                }
                if ((currClassClassLoader = this.getClass().getClassLoader()) != null) {
                    classLoadersUnique.add(currClassClassLoader);
                }
                if ((systemClassLoader = ClassLoader.getSystemClassLoader()) != null) {
                    classLoadersUnique.add(systemClassLoader);
                }
                callStack = null;
                try {
                    callStack = CallStackReader.getClassContext(log);
                    for (int i = callStack.length - 1; i >= 0; --i) {
                        ClassLoader callerClassLoader = callStack[i].getClassLoader();
                        if (callerClassLoader == null) continue;
                        classLoadersUnique.add(callerClassLoader);
                    }
                }
                catch (IllegalArgumentException e) {
                    if (log == null) break block25;
                    log.log("Could not get call stack", e);
                }
            }
            List<ModuleRef> allModuleRefsList = null;
            if (scanSpec.overrideModuleLayers == null) {
                allModuleRefsList = ClassLoaderAndModuleFinder.findModuleRefsFromCallstack(callStack, scanSpec, log);
            } else {
                if (log != null) {
                    LogNode subLog = log.log("Overriding module layers");
                    for (Object moduleLayer : scanSpec.overrideModuleLayers) {
                        subLog.log(moduleLayer.toString());
                    }
                }
                allModuleRefsList = ClassLoaderAndModuleFinder.findModuleRefs(new LinkedHashSet<Object>(scanSpec.overrideModuleLayers), scanSpec, log);
            }
            if (allModuleRefsList != null) {
                this.systemModuleRefs = new ArrayList<ModuleRef>();
                this.nonSystemModuleRefs = new ArrayList<ModuleRef>();
                for (ModuleRef moduleRef : allModuleRefsList) {
                    if (moduleRef.isSystemModule()) {
                        this.systemModuleRefs.add(moduleRef);
                        continue;
                    }
                    this.nonSystemModuleRefs.add(moduleRef);
                }
            }
            if (scanSpec.addedClassLoaders != null) {
                classLoadersUnique.addAll(scanSpec.addedClassLoaders);
            }
            classLoadersFoundLog = log == null ? null : log.log("Found ClassLoaders:");
        } else {
            classLoadersUnique = new LinkedHashSet<ClassLoader>(scanSpec.overrideClassLoaders);
            LogNode logNode = classLoadersFoundLog = log == null ? null : log.log("Override ClassLoaders:");
        }
        if (classLoadersFoundLog != null) {
            for (Object classLoader : classLoadersUnique) {
                classLoadersFoundLog.log(classLoader.getClass().getName());
            }
        }
        if (log != null) {
            LogNode sysSubLog = log.log("Found system modules:");
            if (this.systemModuleRefs != null && !this.systemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : this.systemModuleRefs) {
                    sysSubLog.log(moduleRef.toString());
                }
            } else {
                sysSubLog.log("[None]");
            }
            LogNode nonSysSubLog = log.log("Found non-system modules:");
            if (this.nonSystemModuleRefs != null && !this.nonSystemModuleRefs.isEmpty()) {
                for (ModuleRef moduleRef : this.nonSystemModuleRefs) {
                    nonSysSubLog.log(moduleRef.toString());
                }
            } else {
                nonSysSubLog.log("[None]");
            }
        }
        this.contextClassLoaders = classLoadersUnique.toArray(new ClassLoader[0]);
    }
}

