/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classloaderhandler;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.scanspec.ScanSpec;
import nonapi.io.github.classgraph.utils.LogNode;
import nonapi.io.github.classgraph.utils.ReflectionUtils;

class FelixClassLoaderHandler
implements ClassLoaderHandler {
    private FelixClassLoaderHandler() {
    }

    public static boolean canHandle(ClassLoader classLoader) {
        return "org.apache.felix.framework.BundleWiringImpl$BundleClassLoaderJava5".equals(classLoader.getClass().getName()) || "org.apache.felix.framework.BundleWiringImpl$BundleClassLoader".equals(classLoader.getClass().getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true);
        classLoaderOrder.add(classLoader);
    }

    private static String getContentLocation(Object content) {
        File file = (File)ReflectionUtils.invokeMethod(content, "getFile", false);
        return file != null ? file.toURI().toString() : null;
    }

    private static void addBundle(Object bundleWiring, ClassLoader classLoader, ClasspathOrder classpathOrderOut, Set<Object> bundles, ScanSpec scanSpec, LogNode log) {
        String location;
        bundles.add(bundleWiring);
        Object revision = ReflectionUtils.invokeMethod(bundleWiring, "getRevision", false);
        Object content = ReflectionUtils.invokeMethod(revision, "getContent", false);
        String string = location = content != null ? FelixClassLoaderHandler.getContentLocation(content) : null;
        if (location != null) {
            classpathOrderOut.addClasspathEntry(location, classLoader, scanSpec, log);
            List embeddedContent = (List)ReflectionUtils.invokeMethod(revision, "getContentPath", false);
            if (embeddedContent != null) {
                for (Object embedded : embeddedContent) {
                    String embeddedLocation;
                    if (embedded == content || (embeddedLocation = embedded != null ? FelixClassLoaderHandler.getContentLocation(embedded) : null) == null) continue;
                    classpathOrderOut.addClasspathEntry(embeddedLocation, classLoader, scanSpec, log);
                }
            }
        }
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        HashSet<Object> bundles = new HashSet<Object>();
        Object bundleWiring = ReflectionUtils.getFieldVal(classLoader, "m_wiring", false);
        FelixClassLoaderHandler.addBundle(bundleWiring, classLoader, classpathOrder, bundles, scanSpec, log);
        List requiredWires = (List)ReflectionUtils.invokeMethod(bundleWiring, "getRequiredWires", String.class, null, false);
        if (requiredWires != null) {
            for (Object wire : requiredWires) {
                Object provider = ReflectionUtils.invokeMethod(wire, "getProviderWiring", false);
                if (bundles.contains(provider)) continue;
                FelixClassLoaderHandler.addBundle(provider, classLoader, classpathOrder, bundles, scanSpec, log);
            }
        }
    }
}

