/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals.query;

import org.apache.jena.query.Dataset;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBFactory;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.eclipse.lyo.store.internals.query.JenaQueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetQueryExecutorImpl
implements JenaQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(DatasetQueryExecutorImpl.class);
    private final Dataset dataset;
    private volatile boolean released = false;

    public DatasetQueryExecutorImpl() {
        this(TDBFactory.createDataset());
    }

    public DatasetQueryExecutorImpl(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public QueryExecution prepareSparqlQuery(String query) {
        if (this.released) {
            throw new IllegalStateException("Cannot execute queries after releasing the connection");
        }
        log.debug("Running query: '{}'", (Object)query);
        return QueryExecutionFactory.create((String)query, (Dataset)this.dataset);
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(UpdateRequest updateRequest) {
        if (this.released) {
            throw new IllegalStateException("Cannot execute queries after releasing the connection");
        }
        return UpdateExecutionFactory.create((UpdateRequest)updateRequest, (Dataset)this.dataset);
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(Update update) {
        return this.prepareSparqlUpdate(new UpdateRequest(update));
    }

    @Override
    public UpdateProcessor prepareSparqlUpdate(String query) {
        return this.prepareSparqlUpdate(UpdateFactory.create((String)query));
    }

    @Override
    public void release() {
        TDB.sync((Dataset)this.dataset);
        this.released = true;
        this.dataset.close();
    }

    @Override
    public void beginWrite() {
        this.dataset.begin(ReadWrite.WRITE);
    }

    @Override
    public void beginRead() {
        this.dataset.begin(ReadWrite.READ);
    }

    @Override
    public void commit() {
        this.dataset.commit();
    }

    @Override
    public void end() {
        this.dataset.end();
    }
}

