/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.store.internals;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.jena.arq.querybuilder.AbstractQueryBuilder;
import org.apache.jena.arq.querybuilder.DescribeBuilder;
import org.apache.jena.arq.querybuilder.ExprFactory;
import org.apache.jena.arq.querybuilder.Order;
import org.apache.jena.arq.querybuilder.SelectBuilder;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.modify.request.QuadDataAcc;
import org.apache.jena.sparql.modify.request.UpdateDataInsert;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateProcessor;
import org.eclipse.lyo.core.query.ComparisonTerm;
import org.eclipse.lyo.core.query.DecimalValue;
import org.eclipse.lyo.core.query.PName;
import org.eclipse.lyo.core.query.ParseException;
import org.eclipse.lyo.core.query.QueryUtils;
import org.eclipse.lyo.core.query.SimpleTerm;
import org.eclipse.lyo.core.query.StringValue;
import org.eclipse.lyo.core.query.UriRefValue;
import org.eclipse.lyo.core.query.Value;
import org.eclipse.lyo.core.query.WhereClause;
import org.eclipse.lyo.core.util.StringUtils;
import org.eclipse.lyo.oslc4j.core.OSLC4JUtils;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.model.IResource;
import org.eclipse.lyo.oslc4j.provider.jena.JenaModelHelper;
import org.eclipse.lyo.store.ModelUnmarshallingException;
import org.eclipse.lyo.store.Store;
import org.eclipse.lyo.store.StoreAccessException;
import org.eclipse.lyo.store.internals.query.JenaQueryExecutor;
import org.eclipse.lyo.store.internals.query.SparqlQueryExecutorBasicAuthImpl;
import org.eclipse.lyo.store.internals.query.SparqlQueryExecutorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlStoreImpl
implements Store {
    public static final int TRIPLE_LIMIT = 10001;
    private static final Logger log = LoggerFactory.getLogger(SparqlStoreImpl.class);
    private final JenaQueryExecutor queryExecutor;

    public SparqlStoreImpl(String queryEndpoint, String updateEndpoint) {
        this(new SparqlQueryExecutorImpl(queryEndpoint, updateEndpoint));
    }

    public SparqlStoreImpl(String queryEndpoint, String updateEndpoint, String username, String password) {
        this(new SparqlQueryExecutorBasicAuthImpl(queryEndpoint, updateEndpoint, username, password));
    }

    public SparqlStoreImpl(JenaQueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertJenaModel(URI namedGraph, Model model) {
        QuadDataAcc quadAccumulator = new QuadDataAcc();
        quadAccumulator.setGraph(NodeFactory.createURI((String)String.valueOf(namedGraph)));
        StmtIterator statementIterator = model.listStatements();
        while (statementIterator.hasNext()) {
            Statement statement = statementIterator.nextStatement();
            Triple triple = statement.asTriple();
            quadAccumulator.addTriple(triple);
        }
        this.queryExecutor.beginWrite();
        try {
            UpdateDataInsert dataInsertUpdate = new UpdateDataInsert(quadAccumulator);
            UpdateProcessor up = this.queryExecutor.prepareSparqlUpdate((Update)dataInsertUpdate);
            up.execute();
            this.queryExecutor.commit();
        }
        finally {
            this.queryExecutor.end();
        }
    }

    @Override
    public boolean insertResources(URI namedGraph, Object ... resources) throws StoreAccessException {
        try {
            Model model = JenaModelHelper.createJenaModel((Object[])resources);
            this.insertJenaModel(namedGraph, model);
            return true;
        }
        catch (IllegalAccessException | InvocationTargetException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new StoreAccessException(e);
        }
    }

    @Override
    public void deleteResources(URI namedGraphUri, URI ... subjectUris) {
        QuerySolutionMap map = new QuerySolutionMap();
        for (URI uris : subjectUris) {
            map.clear();
            map.add("graph", (RDFNode)new ResourceImpl(String.valueOf(namedGraphUri)));
            map.add("subject", (RDFNode)new ResourceImpl(String.valueOf(uris)));
            ParameterizedSparqlString sparqlString = new ParameterizedSparqlString("WITH ?graph DELETE  { ?s ?p ?v } WHERE {?s ?p ?v . FILTER(?s = ?subject)}", map);
            String query = sparqlString.toString();
            UpdateProcessor updateProcessor = this.queryExecutor.prepareSparqlUpdate(query);
            updateProcessor.execute();
        }
    }

    @Override
    public void deleteResources(URI namedGraphUri, IResource ... resources) {
        URI[] nodeUris = new URI[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            nodeUris[i] = resources[i].getAbout();
        }
        this.deleteResources(namedGraphUri, nodeUris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean namedGraphExists(URI namedGraphUri) {
        QuerySolutionMap map = new QuerySolutionMap();
        map.add("g", (RDFNode)new ResourceImpl(String.valueOf(namedGraphUri)));
        ParameterizedSparqlString sparqlString = new ParameterizedSparqlString("ASK {GRAPH ?g {?s ?p ?o} }", map);
        String query = sparqlString.toString();
        this.queryExecutor.beginRead();
        try {
            QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query);
            boolean bl = queryExecution.execAsk();
            return bl;
        }
        finally {
            this.queryExecutor.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resourceExists(URI namedGraphUri, URI resourceUri) {
        QuerySolutionMap map = new QuerySolutionMap();
        map.add("g", (RDFNode)new ResourceImpl(String.valueOf(namedGraphUri)));
        map.add("s", (RDFNode)new ResourceImpl(String.valueOf(resourceUri)));
        ParameterizedSparqlString sparqlString = new ParameterizedSparqlString("ASK {GRAPH ?g {?s ?p ?o} }", map);
        String query = sparqlString.toString();
        this.queryExecutor.beginRead();
        try {
            QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query);
            boolean bl = queryExecution.execAsk();
            return bl;
        }
        finally {
            this.queryExecutor.end();
        }
    }

    @Override
    public Model getJenaModelForSubject(URI namedGraphUri, URI subject) throws NoSuchElementException {
        if (!this.namedGraphExists(namedGraphUri)) {
            throw new NoSuchElementException("namedGraph '" + String.valueOf(namedGraphUri) + "' is missing from the triplestore");
        }
        Model model = this.modelFromQueryByUri(namedGraphUri, subject);
        if (model.isEmpty()) {
            throw new NoSuchElementException("resource '" + String.valueOf(subject) + "' is missing from the triplestore at namedGraph '" + String.valueOf(namedGraphUri) + "'");
        }
        return model;
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz) throws StoreAccessException, ModelUnmarshallingException {
        if (this.namedGraphExists(namedGraph)) {
            Model model = this.modelFromQueryFlat(namedGraph);
            return this.getResourcesFromModel(model, clazz);
        }
        throw new IllegalArgumentException("Named graph" + String.valueOf(namedGraph) + " was missing from the triplestore");
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz, int limit, int offset) throws StoreAccessException, ModelUnmarshallingException {
        if (this.namedGraphExists(namedGraph)) {
            Model model = this.modelFromQueryFlatPaged(namedGraph, this.getResourceNsUri(clazz), limit, offset);
            return this.getResourcesFromModel(model, clazz);
        }
        throw new IllegalArgumentException("Named graph" + String.valueOf(namedGraph) + " was missing from the triplestore");
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz, String prefixes, String where, String searchTerms, int limit, int offset) throws StoreAccessException, ModelUnmarshallingException {
        return this.getResources(namedGraph, clazz, prefixes, where, searchTerms, limit, offset, null, null);
    }

    @Override
    public <T extends IResource> List<T> getResources(URI namedGraph, Class<T> clazz, String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) throws StoreAccessException, ModelUnmarshallingException {
        Object _prefixes = prefixes;
        Object _where = where;
        _prefixes = (String)(StringUtils.isNullOrEmpty((String)_prefixes) ? "" : (String)_prefixes + ",") + this.oslcQueryPrefixes(clazz);
        _where = (String)(StringUtils.isNullOrEmpty((String)_where) ? "" : (String)_where + " and ") + this.oslcQueryWhere(clazz);
        Model model = this.getResources(namedGraph, (String)_prefixes, (String)_where, searchTerms, limit, offset, additionalDistinctVars, additionalQueryFilter);
        return this.getResourcesFromModel(model, clazz);
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, int limit, int offset) {
        return this.getResources(namedGraph, prefixes, where, null, limit, offset);
    }

    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, String searchTerms, int limit, int offset) {
        return this.getResources(namedGraph, prefixes, where, searchTerms, limit, offset, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getResources(URI namedGraph, String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) {
        Model execDescribe;
        if (namedGraph != null && !this.namedGraphExists(namedGraph)) {
            throw new IllegalArgumentException("Named graph" + String.valueOf(namedGraph) + " was missing from the triplestore");
        }
        SelectBuilder sparqlWhereQuery = this.constructSparqlWhere(prefixes, where, searchTerms, limit, offset, additionalDistinctVars, additionalQueryFilter);
        DescribeBuilder describeBuilder = new DescribeBuilder();
        describeBuilder.addVar((Object)"s").addGraph(namedGraph != null ? new ResourceImpl(String.valueOf(namedGraph)) : "?g", (AbstractQueryBuilder)sparqlWhereQuery);
        if (null != additionalDistinctVars) {
            for (String additionalDistinctVar : additionalDistinctVars) {
                describeBuilder.addVar((Object)additionalDistinctVar);
            }
        }
        Query describeQuery = describeBuilder.build();
        String describeQueryString = describeQuery.toString();
        this.queryExecutor.beginRead();
        try {
            QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(describeQueryString);
            try {
                log.trace("SPARQL Describe query for oslc.where='{}':\n{}", (Object)where, (Object)describeQueryString);
                Instant start = Instant.now();
                execDescribe = queryExecution.execDescribe();
                Instant finish = Instant.now();
                log.trace("GetResources - SPARQL Query Execution Duration: {} ms", (Object)Duration.between(start, finish).toMillis());
            }
            catch (RiotException e) {
                if (e.getCause() == null && e.getMessage().equals("[line: 2, col: 2 ] Out of place: [DOT]")) {
                    Model model = ModelFactory.createDefaultModel();
                    this.queryExecutor.end();
                    return model;
                }
                throw e;
            }
        }
        finally {
            this.queryExecutor.end();
        }
        return execDescribe;
    }

    @Override
    public <T extends IResource> T getResource(URI namedGraphUri, URI resourceUri, Class<T> clazz) throws NoSuchElementException, StoreAccessException, ModelUnmarshallingException {
        Model model = this.getJenaModelForSubject(namedGraphUri, resourceUri);
        List<T> modelResources = this.getResourcesFromModel(model, clazz);
        if (modelResources == null || modelResources.isEmpty()) {
            throw new NoSuchElementException("Empty Jena model for the subject " + String.valueOf(resourceUri) + ". Use resourceExists(g,r) method to check for resource existence before calling this method.");
        }
        return (T)((IResource)modelResources.get(0));
    }

    @Override
    public <T extends IResource> boolean updateResources(URI namedGraphUri, T ... resources) throws StoreAccessException {
        this.deleteResources(namedGraphUri, (IResource[])resources);
        return this.insertResources(namedGraphUri, resources);
    }

    @Override
    public <T extends IResource> boolean putResources(URI uri, Collection<T> resources) throws StoreAccessException {
        if (this.namedGraphExists(uri)) {
            this.clear(uri);
        }
        return this.insertResources(uri, resources.toArray());
    }

    @Override
    public <T extends IResource> boolean appendResources(URI namedGraph, Collection<T> resources) throws StoreAccessException {
        return this.insertResources(namedGraph, resources.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(URI namedGraph) {
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        ParameterizedSparqlString query = new ParameterizedSparqlString("CLEAR GRAPH ?g", map);
        this.queryExecutor.beginWrite();
        try {
            UpdateProcessor up = this.queryExecutor.prepareSparqlUpdate(query.toString());
            up.execute();
            this.queryExecutor.commit();
        }
        finally {
            this.queryExecutor.end();
        }
    }

    @Override
    @Deprecated
    public Set<String> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll() {
        this.queryExecutor.prepareSparqlUpdate("CLEAR ALL").execute();
    }

    @Override
    public void close() {
        this.queryExecutor.release();
        log.debug("Underlying SPARQL connection has been released");
    }

    private <T extends IResource> String oslcQueryPrefixes(Class<T> clazz) {
        return "rdf=<http://www.w3.org/1999/02/22-rdf-syntax-ns#>";
    }

    private <T extends IResource> String oslcQueryWhere(Class<T> clazz) {
        return "rdf:type=<" + String.valueOf(this.getResourceNsUri(clazz)) + ">";
    }

    private <T extends IResource> List<T> getResourcesFromModel(Model model, Class<T> clazz) throws ModelUnmarshallingException, StoreAccessException {
        try {
            Instant start = Instant.now();
            Object[] obj = JenaModelHelper.fromJenaModel((Model)model, clazz);
            IResource[] castObjects = (IResource[])Array.newInstance(clazz, obj.length);
            for (int i = 0; i < obj.length; ++i) {
                castObjects[i] = (IResource)clazz.cast(obj[i]);
            }
            Instant finish = Instant.now();
            log.trace("getResourcesFromModel - Execution Duration: {} ms", (Object)Duration.between(start, finish).toMillis());
            return Arrays.stream(castObjects).sorted(Comparator.comparing(IResource::getAbout)).collect(Collectors.toList());
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException | URISyntaxException | DatatypeConfigurationException | OslcCoreApplicationException e) {
            throw new ModelUnmarshallingException(e);
        }
        catch (IllegalAccessException e) {
            throw new StoreAccessException(e);
        }
    }

    private <T extends IResource> URI getResourceNsUri(Class<T> clazz) {
        OslcNamespace oslcNamespace = clazz.getAnnotation(OslcNamespace.class);
        OslcName oslcName = clazz.getAnnotation(OslcName.class);
        String name = oslcName != null ? oslcName.value() : clazz.getSimpleName();
        return URI.create(oslcNamespace.value() + name);
    }

    private QuerySolutionMap getGraphMap(URI namedGraph) {
        QuerySolutionMap map = new QuerySolutionMap();
        map.add("g", (RDFNode)new ResourceImpl(String.valueOf(namedGraph)));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model modelFromQueryFlat(URI namedGraph) {
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        String queryTemplate = "DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o } }";
        ParameterizedSparqlString query = new ParameterizedSparqlString("DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o } }", map);
        this.queryExecutor.beginRead();
        try {
            QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query.toString());
            Model model = queryExecution.execDescribe();
            return model;
        }
        finally {
            this.queryExecutor.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model modelFromQueryByUri(URI namedGraph, URI uri) {
        Model execDescribe;
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        map.add("s", (RDFNode)new ResourceImpl(String.valueOf(uri)));
        String queryTemplate = "DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o . } }";
        ParameterizedSparqlString query = new ParameterizedSparqlString("DESCRIBE ?s WHERE { GRAPH ?g { ?s ?p ?o . } }", map);
        this.queryExecutor.beginRead();
        try {
            String queryString = query.toString();
            QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(queryString);
            try {
                log.trace("SPARQL Describe query for uri='{}': \n{}", (Object)uri, (Object)queryString);
                Instant start = Instant.now();
                execDescribe = queryExecution.execDescribe();
                Instant finish = Instant.now();
                log.trace("GetResource - SPARQL Query Execution Duration: {} ms", (Object)Duration.between(start, finish).toMillis());
            }
            catch (RiotException e) {
                if (e.getCause() == null && e.getMessage().equals("[line: 2, col: 2 ] Out of place: [DOT]")) {
                    Model model = ModelFactory.createDefaultModel();
                    this.queryExecutor.end();
                    return model;
                }
                throw e;
            }
        }
        finally {
            this.queryExecutor.end();
        }
        return execDescribe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model modelFromQueryFlatPaged(URI namedGraph, URI type, int limit, int offset) {
        Model m = ModelFactory.createDefaultModel();
        Resource typeResource = m.createResource(type.toString());
        QuerySolutionMap map = this.getGraphMap(namedGraph);
        map.add("t", (RDFNode)typeResource);
        String queryTemplate = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nDESCRIBE ?s\nWHERE {\n  GRAPH ?g {\n    ?s ?p ?o\n    {\n      SELECT DISTINCT ?s\n      WHERE {\n        ?s ?p ?o .\n        ?s rdf:type ?t.\n   }\n      ORDER BY ASC(?s)\n      LIMIT ?l\n      OFFSET ?f\n}\n}\n}\n";
        ParameterizedSparqlString query = new ParameterizedSparqlString("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\nDESCRIBE ?s\nWHERE {\n  GRAPH ?g {\n    ?s ?p ?o\n    {\n      SELECT DISTINCT ?s\n      WHERE {\n        ?s ?p ?o .\n        ?s rdf:type ?t.\n   }\n      ORDER BY ASC(?s)\n      LIMIT ?l\n      OFFSET ?f\n}\n}\n}\n", map);
        query.setLiteral("l", limit);
        query.setLiteral("f", offset);
        this.queryExecutor.beginRead();
        try {
            QueryExecution queryExecution = this.queryExecutor.prepareSparqlQuery(query.toString());
            Model model = queryExecution.execDescribe();
            return model;
        }
        finally {
            this.queryExecutor.end();
        }
    }

    private SelectBuilder constructSparqlWhere(String prefixes, String where, String searchTerms, int limit, int offset, List<String> additionalDistinctVars, SelectBuilder additionalQueryFilter) {
        SelectBuilder distinctResourcesQuery = new SelectBuilder();
        Map prefixesMap = new HashMap();
        try {
            if (!StringUtils.isNullOrEmpty((String)prefixes)) {
                prefixesMap = QueryUtils.parsePrefixes((String)prefixes);
                for (Map.Entry prefix : prefixesMap.entrySet()) {
                    distinctResourcesQuery.addPrefix((String)prefix.getKey(), (String)prefix.getValue());
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("prefixesExpression could not be parsed", e);
        }
        distinctResourcesQuery.addVar((Object)"s").setDistinct(true).addWhere((Object)"?s", (Object)"?p", (Object)"?o");
        if (null != additionalDistinctVars) {
            for (String additionalDistinctVar : additionalDistinctVars) {
                distinctResourcesQuery.addVar((Object)additionalDistinctVar);
            }
        }
        if (null != additionalQueryFilter) {
            distinctResourcesQuery.addWhere((AbstractQueryBuilder)additionalQueryFilter);
        }
        WhereClause whereClause = null;
        try {
            if (!StringUtils.isNullOrEmpty((String)where)) {
                whereClause = QueryUtils.parseWhere((String)where, prefixesMap);
                List parseChildren = whereClause.children();
                block11: for (SimpleTerm simpleTerm : parseChildren) {
                    SimpleTerm.Type termType = simpleTerm.type();
                    PName property = simpleTerm.property();
                    if (!termType.equals((Object)SimpleTerm.Type.COMPARISON)) {
                        throw new UnsupportedOperationException("only support for terms of type Comparisons");
                    }
                    ComparisonTerm aComparisonTerm = (ComparisonTerm)simpleTerm;
                    if (!aComparisonTerm.operator().equals((Object)ComparisonTerm.Operator.EQUALS)) {
                        throw new UnsupportedOperationException("only support for terms of type Comparisons, where the operator is 'EQUALS'");
                    }
                    Value comparisonOperand = aComparisonTerm.operand();
                    Value.Type operandType = comparisonOperand.type();
                    String predicate = property.local.equals("*") ? "?p" : property.toString();
                    switch (operandType) {
                        case DECIMAL: {
                            DecimalValue decimalOperand = (DecimalValue)comparisonOperand;
                            distinctResourcesQuery.addWhere((Object)"?s", (Object)predicate, (Object)decimalOperand.value());
                            continue block11;
                        }
                        case STRING: {
                            StringValue stringOperand = (StringValue)comparisonOperand;
                            distinctResourcesQuery.addWhere((Object)"?s", (Object)predicate, (Object)("\"" + stringOperand.value() + "\""));
                            continue block11;
                        }
                        case URI_REF: {
                            UriRefValue uriOperand = (UriRefValue)comparisonOperand;
                            distinctResourcesQuery.addWhere((Object)"?s", (Object)predicate, (Object)new ResourceImpl(uriOperand.value()));
                            continue block11;
                        }
                    }
                    throw new UnsupportedOperationException("only support for terms of type Comparisons, where the operator is 'EQUALS', and the operand is either a String, an Integer or a URI");
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("whereExpression could not be parsed", e);
        }
        if (!StringUtils.isNullOrEmpty((String)searchTerms)) {
            ExprFactory factory = new ExprFactory();
            E_Regex regex = factory.regex((Object)factory.str((Object)"?o"), searchTerms, "i");
            distinctResourcesQuery.addFilter((Expr)regex);
        }
        if (!(limit <= 0 && offset <= 0 || OSLC4JUtils.isLyoStorePagingUnsafe())) {
            distinctResourcesQuery.addOrderBy((Object)"?s", Order.ASCENDING);
        }
        if (limit > 0) {
            distinctResourcesQuery.setLimit(limit);
        }
        if (offset > 0) {
            distinctResourcesQuery.setOffset(offset);
        }
        SelectBuilder constructSelectQuery = new SelectBuilder();
        constructSelectQuery.addVar((Object)"s p o").addSubQuery((AbstractQueryBuilder)distinctResourcesQuery);
        return constructSelectQuery;
    }
}

