/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.java.codeaction;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.codeaction.CodeActionResolveData;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.ExtendedCodeAction;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.IJavaCodeActionParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionContext;
import org.eclipse.lsp4mp.jdt.core.java.codeaction.JavaCodeActionResolveContext;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.JavaFeaturesRegistry;
import org.eclipse.lsp4mp.jdt.internal.core.java.codeaction.JavaCodeActionDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.corrections.DiagnosticsHelper;

public class CodeActionHandler {
    public List<? extends CodeAction> codeAction(MicroProfileJavaCodeActionParams params, IJDTUtils utils, IProgressMonitor monitor) {
        String uri = params.getUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        if (unit == null) {
            return Collections.emptyList();
        }
        int start = DiagnosticsHelper.getStartOffset(unit, params.getRange(), utils);
        int end = DiagnosticsHelper.getEndOffset(unit, params.getRange(), utils);
        JavaCodeActionContext context = new JavaCodeActionContext((ITypeRoot)unit, start, end - start, utils, params);
        context.setASTRoot(CodeActionHandler.getASTRoot(unit, monitor));
        ArrayList<String> codeActionKinds = new ArrayList<String>();
        if (params.getContext().getOnly() != null && !params.getContext().getOnly().isEmpty()) {
            codeActionKinds.addAll(params.getContext().getOnly());
        } else {
            List<String> defaultCodeActionKinds = Arrays.asList("quickfix", "refactor", "source");
            codeActionKinds.addAll(defaultCodeActionKinds);
        }
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        HashMap<String, ArrayList<JavaCodeActionDefinition>> forDiagnostics = new HashMap<String, ArrayList<JavaCodeActionDefinition>>();
        for (String codeActionKind : codeActionKinds) {
            List codeActionDefinitions = JavaFeaturesRegistry.getInstance().getJavaCodeActionDefinitions(codeActionKind).stream().filter(definition -> definition.isAdaptedForCodeAction(context, monitor)).collect(Collectors.toList());
            if (codeActionDefinitions == null) continue;
            for (JavaCodeActionDefinition definition2 : codeActionDefinitions) {
                String forDiagnostic = definition2.getTargetDiagnostic();
                if (forDiagnostic != null) {
                    ArrayList<JavaCodeActionDefinition> definitionsFor = (ArrayList<JavaCodeActionDefinition>)forDiagnostics.get(forDiagnostic);
                    if (definitionsFor == null) {
                        definitionsFor = new ArrayList<JavaCodeActionDefinition>();
                        forDiagnostics.put(forDiagnostic, definitionsFor);
                    }
                    definitionsFor.add(definition2);
                    continue;
                }
                codeActions.addAll(definition2.getCodeActions(context, null, monitor));
            }
        }
        if (!forDiagnostics.isEmpty()) {
            params.getContext().getDiagnostics().forEach(diagnostic -> {
                String code = CodeActionHandler.getCode(diagnostic);
                if (code != null) {
                    String key = String.valueOf(diagnostic.getSource()) + "#" + code;
                    List definitionsFor = (List)forDiagnostics.get(key);
                    if (definitionsFor == null) {
                        definitionsFor = (List)forDiagnostics.get(code);
                    }
                    if (definitionsFor != null) {
                        for (JavaCodeActionDefinition definition : definitionsFor) {
                            codeActions.addAll(definition.getCodeActions(context, (Diagnostic)diagnostic, monitor));
                        }
                    }
                }
            });
        }
        if (!params.isResolveSupported()) {
            List<CodeAction> resolvedCodeActions = codeActions.stream().map(codeAction -> {
                if (codeAction.getEdit() != null || codeAction.getCommand() != null) {
                    return codeAction;
                }
                return this.resolveCodeAction((CodeAction)codeAction, utils, monitor);
            }).collect(Collectors.toList());
            ExtendedCodeAction.sort(resolvedCodeActions);
            return resolvedCodeActions;
        }
        ExtendedCodeAction.sort(codeActions);
        return codeActions;
    }

    public CodeAction resolveCodeAction(CodeAction unresolved, IJDTUtils utils, IProgressMonitor monitor) {
        CodeActionResolveData data = (CodeActionResolveData)unresolved.getData();
        String participantId = data.getParticipantId();
        String uri = data.getDocumentUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        if (unit == null) {
            return null;
        }
        int start = DiagnosticsHelper.getStartOffset(unit, data.getRange(), utils);
        int end = DiagnosticsHelper.getEndOffset(unit, data.getRange(), utils);
        MicroProfileJavaCodeActionParams params = new MicroProfileJavaCodeActionParams();
        params.setContext(new CodeActionContext(unresolved.getDiagnostics() == null ? Collections.emptyList() : unresolved.getDiagnostics()));
        params.setResourceOperationSupported(data.isResourceOperationSupported());
        params.setCommandConfigurationUpdateSupported(data.isCommandConfigurationUpdateSupported());
        params.setRange(data.getRange());
        params.setTextDocument((TextDocumentIdentifier)new VersionedTextDocumentIdentifier(uri, null));
        JavaCodeActionResolveContext context = new JavaCodeActionResolveContext((ITypeRoot)unit, start, end - start, utils, params, unresolved);
        context.setASTRoot(CodeActionHandler.getASTRoot(unit, monitor));
        IJavaCodeActionParticipant participant = JavaFeaturesRegistry.getInstance().getJavaCodeActionDefinitions(unresolved.getKind()).stream().filter(definition -> participantId.equals(definition.getParticipantId())).findFirst().orElse(null);
        return participant.resolveCodeAction(context);
    }

    private static CompilationUnit getASTRoot(ICompilationUnit unit, IProgressMonitor monitor) {
        return CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
    }

    private static String getCode(Diagnostic diagnostic) {
        Object code = null;
        try {
            Field f = diagnostic.getClass().getDeclaredField("code");
            f.setAccessible(true);
            code = f.get(diagnostic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CodeActionHandler.getCodeString(code);
    }

    private static String getCodeString(Object codeObject) {
        if (codeObject instanceof String) {
            return (String)codeObject;
        }
        Either code = (Either)codeObject;
        if (code == null || code.isRight()) {
            return null;
        }
        return (String)code.getLeft();
    }
}

